<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginResponse StructType
 * Meta informations extracted from the WSDL
 * - type: LoginResponse
 * @subpackage Structs
 */
class LoginResponse extends AbstractStructBase
{
    /**
     * The SESSION_ID
     * @var string
     */
    public $SESSION_ID;
    /**
     * The ERROR_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\REQUEST_ERRORType
     */
    public $ERROR_TYPE;
    /**
     * Constructor method for LoginResponse
     * @uses LoginResponse::setSESSION_ID()
     * @uses LoginResponse::setERROR_TYPE()
     * @param string $sESSION_ID
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     */
    public function __construct($sESSION_ID = null, \StructType\REQUEST_ERRORType $eRROR_TYPE = null)
    {
        $this
            ->setSESSION_ID($sESSION_ID)
            ->setERROR_TYPE($eRROR_TYPE);
    }
    /**
     * Get SESSION_ID value
     * @return string|null
     */
    public function getSESSION_ID()
    {
        return $this->SESSION_ID;
    }
    /**
     * Set SESSION_ID value
     * @param string $sESSION_ID
     * @return \StructType\LoginResponse
     */
    public function setSESSION_ID($sESSION_ID = null)
    {
        // validation for constraint: string
        if (!is_null($sESSION_ID) && !is_string($sESSION_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sESSION_ID)), __LINE__);
        }
        $this->SESSION_ID = $sESSION_ID;
        return $this;
    }
    /**
     * Get ERROR_TYPE value
     * @return \StructType\REQUEST_ERRORType|null
     */
    public function getERROR_TYPE()
    {
        return $this->ERROR_TYPE;
    }
    /**
     * Set ERROR_TYPE value
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     * @return \StructType\LoginResponse
     */
    public function setERROR_TYPE(\StructType\REQUEST_ERRORType $eRROR_TYPE = null)
    {
        $this->ERROR_TYPE = $eRROR_TYPE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoginResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
