<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserAuthorizationResponse StructType
 * Meta informations extracted from the WSDL
 * - type: GetUserAuthorizationResponse
 * @subpackage Structs
 */
class GetUserAuthorizationResponse extends AbstractStructBase
{
    /**
     * The AUTHORIZED
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AUTHORIZED;
    /**
     * The ERROR_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\REQUEST_ERRORType
     */
    public $ERROR_TYPE;
    /**
     * The PRODUCT_LIST
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PRODUCT_LIST
     */
    public $PRODUCT_LIST;
    /**
     * Constructor method for GetUserAuthorizationResponse
     * @uses GetUserAuthorizationResponse::setAUTHORIZED()
     * @uses GetUserAuthorizationResponse::setERROR_TYPE()
     * @uses GetUserAuthorizationResponse::setPRODUCT_LIST()
     * @param string $aUTHORIZED
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     * @param \StructType\PRODUCT_LIST $pRODUCT_LIST
     */
    public function __construct($aUTHORIZED = null, \StructType\REQUEST_ERRORType $eRROR_TYPE = null, \StructType\PRODUCT_LIST $pRODUCT_LIST = null)
    {
        $this
            ->setAUTHORIZED($aUTHORIZED)
            ->setERROR_TYPE($eRROR_TYPE)
            ->setPRODUCT_LIST($pRODUCT_LIST);
    }
    /**
     * Get AUTHORIZED value
     * @return string|null
     */
    public function getAUTHORIZED()
    {
        return $this->AUTHORIZED;
    }
    /**
     * Set AUTHORIZED value
     * @uses \EnumType\AUTHORIZED::valueIsValid()
     * @uses \EnumType\AUTHORIZED::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $aUTHORIZED
     * @return \StructType\GetUserAuthorizationResponse
     */
    public function setAUTHORIZED($aUTHORIZED = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AUTHORIZED::valueIsValid($aUTHORIZED)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $aUTHORIZED, implode(', ', \EnumType\AUTHORIZED::getValidValues())), __LINE__);
        }
        $this->AUTHORIZED = $aUTHORIZED;
        return $this;
    }
    /**
     * Get ERROR_TYPE value
     * @return \StructType\REQUEST_ERRORType|null
     */
    public function getERROR_TYPE()
    {
        return $this->ERROR_TYPE;
    }
    /**
     * Set ERROR_TYPE value
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     * @return \StructType\GetUserAuthorizationResponse
     */
    public function setERROR_TYPE(\StructType\REQUEST_ERRORType $eRROR_TYPE = null)
    {
        $this->ERROR_TYPE = $eRROR_TYPE;
        return $this;
    }
    /**
     * Get PRODUCT_LIST value
     * @return \StructType\PRODUCT_LIST|null
     */
    public function getPRODUCT_LIST()
    {
        return $this->PRODUCT_LIST;
    }
    /**
     * Set PRODUCT_LIST value
     * @param \StructType\PRODUCT_LIST $pRODUCT_LIST
     * @return \StructType\GetUserAuthorizationResponse
     */
    public function setPRODUCT_LIST(\StructType\PRODUCT_LIST $pRODUCT_LIST = null)
    {
        $this->PRODUCT_LIST = $pRODUCT_LIST;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetUserAuthorizationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
