<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PARTINFO StructType
 * @subpackage Structs
 */
class PARTINFO extends AbstractStructBase
{
    /**
     * The VKN
     * @var string
     */
    public $VKN;
    /**
     * The IDENTIFIER
     * @var string
     */
    public $IDENTIFIER;
    /**
     * Constructor method for PARTINFO
     * @uses PARTINFO::setVKN()
     * @uses PARTINFO::setIDENTIFIER()
     * @param string $vKN
     * @param string $iDENTIFIER
     */
    public function __construct($vKN = null, $iDENTIFIER = null)
    {
        $this
            ->setVKN($vKN)
            ->setIDENTIFIER($iDENTIFIER);
    }
    /**
     * Get VKN value
     * @return string|null
     */
    public function getVKN()
    {
        return $this->VKN;
    }
    /**
     * Set VKN value
     * @param string $vKN
     * @return \StructType\PARTINFO
     */
    public function setVKN($vKN = null)
    {
        // validation for constraint: string
        if (!is_null($vKN) && !is_string($vKN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vKN)), __LINE__);
        }
        $this->VKN = $vKN;
        return $this;
    }
    /**
     * Get IDENTIFIER value
     * @return string|null
     */
    public function getIDENTIFIER()
    {
        return $this->IDENTIFIER;
    }
    /**
     * Set IDENTIFIER value
     * @param string $iDENTIFIER
     * @return \StructType\PARTINFO
     */
    public function setIDENTIFIER($iDENTIFIER = null)
    {
        // validation for constraint: string
        if (!is_null($iDENTIFIER) && !is_string($iDENTIFIER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDENTIFIER)), __LINE__);
        }
        $this->IDENTIFIER = $iDENTIFIER;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PARTINFO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
