<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.accell-it-services.com:9080/WSHP_AWWSAVO/services/AWWSAVOServices/wsdl/AWWSAVOServices.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.accell-it-services.com:9080/WSHP_AWWSAVO/services/AWWSAVOServices/wsdl/AWWSAVOServices.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Awwsavo ServiceType
 */
$awwsavo = new \ServiceType\Awwsavo($options);
/**
 * Sample call for awwsavo operation/method
 */
if ($awwsavo->awwsavo(new \StructType\Awwsavo()) !== false) {
    print_r($awwsavo->getResult());
} else {
    print_r($awwsavo->getLastError());
}
/**
 * Sample call for awwsavo_XML operation/method
 */
if ($awwsavo->awwsavo_XML(new \StructType\Awwsavo_XML()) !== false) {
    print_r($awwsavo->getResult());
} else {
    print_r($awwsavo->getLastError());
}
