<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AWWSAVOResult StructType
 * @subpackage Structs
 */
class AWWSAVOResult extends AbstractStructBase
{
    /**
     * The returncode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $returncode;
    /**
     * The melding
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $melding;
    /**
     * The voorraadinfo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Voorraadinfo
     */
    public $voorraadinfo;
    /**
     * Constructor method for AWWSAVOResult
     * @uses AWWSAVOResult::setReturncode()
     * @uses AWWSAVOResult::setMelding()
     * @uses AWWSAVOResult::setVoorraadinfo()
     * @param string $returncode
     * @param string $melding
     * @param \StructType\Voorraadinfo $voorraadinfo
     */
    public function __construct($returncode = null, $melding = null, \StructType\Voorraadinfo $voorraadinfo = null)
    {
        $this
            ->setReturncode($returncode)
            ->setMelding($melding)
            ->setVoorraadinfo($voorraadinfo);
    }
    /**
     * Get returncode value
     * @return string|null
     */
    public function getReturncode()
    {
        return $this->returncode;
    }
    /**
     * Set returncode value
     * @param string $returncode
     * @return \StructType\AWWSAVOResult
     */
    public function setReturncode($returncode = null)
    {
        // validation for constraint: string
        if (!is_null($returncode) && !is_string($returncode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returncode)), __LINE__);
        }
        $this->returncode = $returncode;
        return $this;
    }
    /**
     * Get melding value
     * @return string|null
     */
    public function getMelding()
    {
        return $this->melding;
    }
    /**
     * Set melding value
     * @param string $melding
     * @return \StructType\AWWSAVOResult
     */
    public function setMelding($melding = null)
    {
        // validation for constraint: string
        if (!is_null($melding) && !is_string($melding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($melding)), __LINE__);
        }
        $this->melding = $melding;
        return $this;
    }
    /**
     * Get voorraadinfo value
     * @return \StructType\Voorraadinfo|null
     */
    public function getVoorraadinfo()
    {
        return $this->voorraadinfo;
    }
    /**
     * Set voorraadinfo value
     * @param \StructType\Voorraadinfo $voorraadinfo
     * @return \StructType\AWWSAVOResult
     */
    public function setVoorraadinfo(\StructType\Voorraadinfo $voorraadinfo = null)
    {
        $this->voorraadinfo = $voorraadinfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AWWSAVOResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
