<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AWWSAVOInput StructType
 * @subpackage Structs
 */
class AWWSAVOInput extends AbstractStructBase
{
    /**
     * The returncode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $returncode;
    /**
     * The leveranciercode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $leveranciercode;
    /**
     * The usercode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $usercode;
    /**
     * The wachtwoord
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $wachtwoord;
    /**
     * The artikelnummer
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $artikelnummer;
    /**
     * Constructor method for AWWSAVOInput
     * @uses AWWSAVOInput::setReturncode()
     * @uses AWWSAVOInput::setLeveranciercode()
     * @uses AWWSAVOInput::setUsercode()
     * @uses AWWSAVOInput::setWachtwoord()
     * @uses AWWSAVOInput::setArtikelnummer()
     * @param string $returncode
     * @param string $leveranciercode
     * @param string $usercode
     * @param string $wachtwoord
     * @param string $artikelnummer
     */
    public function __construct($returncode = null, $leveranciercode = null, $usercode = null, $wachtwoord = null, $artikelnummer = null)
    {
        $this
            ->setReturncode($returncode)
            ->setLeveranciercode($leveranciercode)
            ->setUsercode($usercode)
            ->setWachtwoord($wachtwoord)
            ->setArtikelnummer($artikelnummer);
    }
    /**
     * Get returncode value
     * @return string|null
     */
    public function getReturncode()
    {
        return $this->returncode;
    }
    /**
     * Set returncode value
     * @param string $returncode
     * @return \StructType\AWWSAVOInput
     */
    public function setReturncode($returncode = null)
    {
        // validation for constraint: string
        if (!is_null($returncode) && !is_string($returncode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returncode)), __LINE__);
        }
        $this->returncode = $returncode;
        return $this;
    }
    /**
     * Get leveranciercode value
     * @return string|null
     */
    public function getLeveranciercode()
    {
        return $this->leveranciercode;
    }
    /**
     * Set leveranciercode value
     * @param string $leveranciercode
     * @return \StructType\AWWSAVOInput
     */
    public function setLeveranciercode($leveranciercode = null)
    {
        // validation for constraint: string
        if (!is_null($leveranciercode) && !is_string($leveranciercode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leveranciercode)), __LINE__);
        }
        $this->leveranciercode = $leveranciercode;
        return $this;
    }
    /**
     * Get usercode value
     * @return string|null
     */
    public function getUsercode()
    {
        return $this->usercode;
    }
    /**
     * Set usercode value
     * @param string $usercode
     * @return \StructType\AWWSAVOInput
     */
    public function setUsercode($usercode = null)
    {
        // validation for constraint: string
        if (!is_null($usercode) && !is_string($usercode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usercode)), __LINE__);
        }
        $this->usercode = $usercode;
        return $this;
    }
    /**
     * Get wachtwoord value
     * @return string|null
     */
    public function getWachtwoord()
    {
        return $this->wachtwoord;
    }
    /**
     * Set wachtwoord value
     * @param string $wachtwoord
     * @return \StructType\AWWSAVOInput
     */
    public function setWachtwoord($wachtwoord = null)
    {
        // validation for constraint: string
        if (!is_null($wachtwoord) && !is_string($wachtwoord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wachtwoord)), __LINE__);
        }
        $this->wachtwoord = $wachtwoord;
        return $this;
    }
    /**
     * Get artikelnummer value
     * @return string|null
     */
    public function getArtikelnummer()
    {
        return $this->artikelnummer;
    }
    /**
     * Set artikelnummer value
     * @param string $artikelnummer
     * @return \StructType\AWWSAVOInput
     */
    public function setArtikelnummer($artikelnummer = null)
    {
        // validation for constraint: string
        if (!is_null($artikelnummer) && !is_string($artikelnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artikelnummer)), __LINE__);
        }
        $this->artikelnummer = $artikelnummer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AWWSAVOInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
