<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Awwsavo ServiceType
 * @subpackage Services
 */
class Awwsavo extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named awwsavo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Awwsavo $parameters
     * @return \StructType\AwwsavoResponse|bool
     */
    public function awwsavo(\StructType\Awwsavo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->awwsavo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named awwsavo_XML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Awwsavo_XML $parameters
     * @return \StructType\Awwsavo_XMLResponse|bool
     */
    public function awwsavo_XML(\StructType\Awwsavo_XML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->awwsavo_XML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AwwsavoResponse|\StructType\Awwsavo_XMLResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
