<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateUser operation/method
 */
if ($create->CreateUser(new \StructType\CreateUserDefaultEmail()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateGroup operation/method
 */
if ($create->CreateGroup(new \StructType\CreateGroup()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddAttributeToGUMUser operation/method
 */
if ($add->AddAttributeToGUMUser(new \StructType\AddAttributeToGUMUser()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddFutureDateTimeToGUMUser operation/method
 */
if ($add->AddFutureDateTimeToGUMUser(new \StructType\AddFutureDateTimeToGUMUser()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddPreferredLanguageToGUMUser operation/method
 */
if ($add->AddPreferredLanguageToGUMUser(new \StructType\AddPreferredLanguageToGUMUser()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDelegatedOwner operation/method
 */
if ($add->AddDelegatedOwner(new \StructType\AddDelegatedOwner()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddGroupOwner operation/method
 */
if ($add->AddGroupOwner(new \StructType\AddGroupOwner()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddGroupMember operation/method
 */
if ($add->AddGroupMember(new \StructType\AddGroupMember()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
/**
 * Sample call for ValidateUserByEmail operation/method
 */
if ($validate->ValidateUserByEmail(new \StructType\ValidateUserByEmail()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateUserByGuid operation/method
 */
if ($validate->ValidateUserByGuid(new \StructType\ValidateUserByGuid()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateGroupByGuid operation/method
 */
if ($validate->ValidateGroupByGuid(new \StructType\ValidateGroupByGuid()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetCredentials operation/method
 */
if ($set->SetCredentials(new \StructType\SetCredentials()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetApplicationNames operation/method
 */
if ($get->GetApplicationNames(new \StructType\GetApplicationNames()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateUser operation/method
 */
if ($update->UpdateUser(new \StructType\UpdateUser()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAssuranceLevel operation/method
 */
if ($update->UpdateAssuranceLevel(new \StructType\UpdateAssuranceLevel()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateGroupDisplayedOwner operation/method
 */
if ($update->UpdateGroupDisplayedOwner(new \StructType\UpdateGroupDisplayedOwner()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateGroup operation/method
 */
if ($update->UpdateGroup(new \StructType\UpdateGroup()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Reset ServiceType
 */
$reset = new \ServiceType\Reset($options);
/**
 * Sample call for ResetPassword operation/method
 */
if ($reset->ResetPassword(new \StructType\ResetPassword()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Sample call for ResetQuestions operation/method
 */
if ($reset->ResetQuestions(new \StructType\ResetQuestions()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Samples for Lock ServiceType
 */
$lock = new \ServiceType\Lock($options);
/**
 * Sample call for LockAccount operation/method
 */
if ($lock->LockAccount(new \StructType\LockAccount()) !== false) {
    print_r($lock->getResult());
} else {
    print_r($lock->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
/**
 * Sample call for RemoveDelegatedOwner operation/method
 */
if ($remove->RemoveDelegatedOwner(new \StructType\RemoveDelegatedOwner()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveGroupOwner operation/method
 */
if ($remove->RemoveGroupOwner(new \StructType\RemoveGroupOwner()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveGroupMember operation/method
 */
if ($remove->RemoveGroupMember(new \StructType\RemoveGroupMember()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Unused ServiceType
 */
$unused = new \ServiceType\Unused($options);
/**
 * Sample call for UnusedGroupMethod operation/method
 */
if ($unused->UnusedGroupMethod(new \StructType\UnusedGroupMethod()) !== false) {
    print_r($unused->getResult());
} else {
    print_r($unused->getLastError());
}
