<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnStatus StructType
 * @subpackage Structs
 */
class ReturnStatus extends AbstractStructBase
{
    /**
     * The ReturnCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReturnCode;
    /**
     * The ReturnCodeDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnCodeDescription;
    /**
     * The ReturnedUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GUMUser
     */
    public $ReturnedUser;
    /**
     * The ReturnedGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GUMGroup
     */
    public $ReturnedGroup;
    /**
     * The ReturnedCredential
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Credential
     */
    public $ReturnedCredential;
    /**
     * The ApplicationNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $ApplicationNames;
    /**
     * Constructor method for ReturnStatus
     * @uses ReturnStatus::setReturnCode()
     * @uses ReturnStatus::setReturnCodeDescription()
     * @uses ReturnStatus::setReturnedUser()
     * @uses ReturnStatus::setReturnedGroup()
     * @uses ReturnStatus::setReturnedCredential()
     * @uses ReturnStatus::setApplicationNames()
     * @param string $returnCode
     * @param string $returnCodeDescription
     * @param \StructType\GUMUser $returnedUser
     * @param \StructType\GUMGroup $returnedGroup
     * @param \StructType\Credential $returnedCredential
     * @param \ArrayType\ArrayOfString $applicationNames
     */
    public function __construct($returnCode = null, $returnCodeDescription = null, \StructType\GUMUser $returnedUser = null, \StructType\GUMGroup $returnedGroup = null, \StructType\Credential $returnedCredential = null, \ArrayType\ArrayOfString $applicationNames = null)
    {
        $this
            ->setReturnCode($returnCode)
            ->setReturnCodeDescription($returnCodeDescription)
            ->setReturnedUser($returnedUser)
            ->setReturnedGroup($returnedGroup)
            ->setReturnedCredential($returnedCredential)
            ->setApplicationNames($applicationNames);
    }
    /**
     * Get ReturnCode value
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }
    /**
     * Set ReturnCode value
     * @uses \EnumType\Status_Codes::valueIsValid()
     * @uses \EnumType\Status_Codes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $returnCode
     * @return \StructType\ReturnStatus
     */
    public function setReturnCode($returnCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Status_Codes::valueIsValid($returnCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $returnCode, implode(', ', \EnumType\Status_Codes::getValidValues())), __LINE__);
        }
        $this->ReturnCode = $returnCode;
        return $this;
    }
    /**
     * Get ReturnCodeDescription value
     * @return string|null
     */
    public function getReturnCodeDescription()
    {
        return $this->ReturnCodeDescription;
    }
    /**
     * Set ReturnCodeDescription value
     * @param string $returnCodeDescription
     * @return \StructType\ReturnStatus
     */
    public function setReturnCodeDescription($returnCodeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($returnCodeDescription) && !is_string($returnCodeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnCodeDescription)), __LINE__);
        }
        $this->ReturnCodeDescription = $returnCodeDescription;
        return $this;
    }
    /**
     * Get ReturnedUser value
     * @return \StructType\GUMUser|null
     */
    public function getReturnedUser()
    {
        return $this->ReturnedUser;
    }
    /**
     * Set ReturnedUser value
     * @param \StructType\GUMUser $returnedUser
     * @return \StructType\ReturnStatus
     */
    public function setReturnedUser(\StructType\GUMUser $returnedUser = null)
    {
        $this->ReturnedUser = $returnedUser;
        return $this;
    }
    /**
     * Get ReturnedGroup value
     * @return \StructType\GUMGroup|null
     */
    public function getReturnedGroup()
    {
        return $this->ReturnedGroup;
    }
    /**
     * Set ReturnedGroup value
     * @param \StructType\GUMGroup $returnedGroup
     * @return \StructType\ReturnStatus
     */
    public function setReturnedGroup(\StructType\GUMGroup $returnedGroup = null)
    {
        $this->ReturnedGroup = $returnedGroup;
        return $this;
    }
    /**
     * Get ReturnedCredential value
     * @return \StructType\Credential|null
     */
    public function getReturnedCredential()
    {
        return $this->ReturnedCredential;
    }
    /**
     * Set ReturnedCredential value
     * @param \StructType\Credential $returnedCredential
     * @return \StructType\ReturnStatus
     */
    public function setReturnedCredential(\StructType\Credential $returnedCredential = null)
    {
        $this->ReturnedCredential = $returnedCredential;
        return $this;
    }
    /**
     * Get ApplicationNames value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getApplicationNames()
    {
        return $this->ApplicationNames;
    }
    /**
     * Set ApplicationNames value
     * @param \ArrayType\ArrayOfString $applicationNames
     * @return \StructType\ReturnStatus
     */
    public function setApplicationNames(\ArrayType\ArrayOfString $applicationNames = null)
    {
        $this->ApplicationNames = $applicationNames;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReturnStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
