<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GUMGroup StructType
 * @subpackage Structs
 */
class GUMGroup extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The AccountName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountName;
    /**
     * The Domain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Domain;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Owners
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Owners;
    /**
     * The DisplayedOwner
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayedOwner;
    /**
     * The Members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Members;
    /**
     * Constructor method for GUMGroup
     * @uses GUMGroup::setDisplayName()
     * @uses GUMGroup::setAccountName()
     * @uses GUMGroup::setDomain()
     * @uses GUMGroup::setDescription()
     * @uses GUMGroup::setOwners()
     * @uses GUMGroup::setDisplayedOwner()
     * @uses GUMGroup::setMembers()
     * @param string $displayName
     * @param string $accountName
     * @param string $domain
     * @param string $description
     * @param \ArrayType\ArrayOfString $owners
     * @param string $displayedOwner
     * @param \ArrayType\ArrayOfString $members
     */
    public function __construct($displayName = null, $accountName = null, $domain = null, $description = null, \ArrayType\ArrayOfString $owners = null, $displayedOwner = null, \ArrayType\ArrayOfString $members = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setAccountName($accountName)
            ->setDomain($domain)
            ->setDescription($description)
            ->setOwners($owners)
            ->setDisplayedOwner($displayedOwner)
            ->setMembers($members);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\GUMGroup
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get AccountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->AccountName;
    }
    /**
     * Set AccountName value
     * @param string $accountName
     * @return \StructType\GUMGroup
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountName)), __LINE__);
        }
        $this->AccountName = $accountName;
        return $this;
    }
    /**
     * Get Domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->Domain;
    }
    /**
     * Set Domain value
     * @param string $domain
     * @return \StructType\GUMGroup
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->Domain = $domain;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\GUMGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Owners value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getOwners()
    {
        return $this->Owners;
    }
    /**
     * Set Owners value
     * @param \ArrayType\ArrayOfString $owners
     * @return \StructType\GUMGroup
     */
    public function setOwners(\ArrayType\ArrayOfString $owners = null)
    {
        $this->Owners = $owners;
        return $this;
    }
    /**
     * Get DisplayedOwner value
     * @return string|null
     */
    public function getDisplayedOwner()
    {
        return $this->DisplayedOwner;
    }
    /**
     * Set DisplayedOwner value
     * @param string $displayedOwner
     * @return \StructType\GUMGroup
     */
    public function setDisplayedOwner($displayedOwner = null)
    {
        // validation for constraint: string
        if (!is_null($displayedOwner) && !is_string($displayedOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayedOwner)), __LINE__);
        }
        $this->DisplayedOwner = $displayedOwner;
        return $this;
    }
    /**
     * Get Members value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getMembers()
    {
        return $this->Members;
    }
    /**
     * Set Members value
     * @param \ArrayType\ArrayOfString $members
     * @return \StructType\GUMGroup
     */
    public function setMembers(\ArrayType\ArrayOfString $members = null)
    {
        $this->Members = $members;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GUMGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
