<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attribute StructType
 * @subpackage Structs
 */
class Attribute extends AbstractStructBase
{
    /**
     * The AttributeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AttributeName;
    /**
     * The AttributeValues
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnyType
     */
    public $AttributeValues;
    /**
     * Constructor method for Attribute
     * @uses Attribute::setAttributeName()
     * @uses Attribute::setAttributeValues()
     * @param string $attributeName
     * @param \ArrayType\ArrayOfAnyType $attributeValues
     */
    public function __construct($attributeName = null, \ArrayType\ArrayOfAnyType $attributeValues = null)
    {
        $this
            ->setAttributeName($attributeName)
            ->setAttributeValues($attributeValues);
    }
    /**
     * Get AttributeName value
     * @return string|null
     */
    public function getAttributeName()
    {
        return $this->AttributeName;
    }
    /**
     * Set AttributeName value
     * @param string $attributeName
     * @return \StructType\Attribute
     */
    public function setAttributeName($attributeName = null)
    {
        // validation for constraint: string
        if (!is_null($attributeName) && !is_string($attributeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributeName)), __LINE__);
        }
        $this->AttributeName = $attributeName;
        return $this;
    }
    /**
     * Get AttributeValues value
     * @return \ArrayType\ArrayOfAnyType|null
     */
    public function getAttributeValues()
    {
        return $this->AttributeValues;
    }
    /**
     * Set AttributeValues value
     * @param \ArrayType\ArrayOfAnyType $attributeValues
     * @return \StructType\Attribute
     */
    public function setAttributeValues(\ArrayType\ArrayOfAnyType $attributeValues = null)
    {
        $this->AttributeValues = $attributeValues;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Attribute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
