<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddAttributeToGUMUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAttributeToGUMUser $parameters
     * @return \StructType\AddAttributeToGUMUserResponse|bool
     */
    public function AddAttributeToGUMUser(\StructType\AddAttributeToGUMUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddAttributeToGUMUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddFutureDateTimeToGUMUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddFutureDateTimeToGUMUser $parameters
     * @return \StructType\AddFutureDateTimeToGUMUserResponse|bool
     */
    public function AddFutureDateTimeToGUMUser(\StructType\AddFutureDateTimeToGUMUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddFutureDateTimeToGUMUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddPreferredLanguageToGUMUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddPreferredLanguageToGUMUser $parameters
     * @return \StructType\AddPreferredLanguageToGUMUserResponse|bool
     */
    public function AddPreferredLanguageToGUMUser(\StructType\AddPreferredLanguageToGUMUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddPreferredLanguageToGUMUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDelegatedOwner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDelegatedOwner $parameters
     * @return \StructType\AddDelegatedOwnerResponse|bool
     */
    public function AddDelegatedOwner(\StructType\AddDelegatedOwner $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddDelegatedOwner($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddGroupOwner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGroupOwner $parameters
     * @return \StructType\AddGroupOwnerResponse|bool
     */
    public function AddGroupOwner(\StructType\AddGroupOwner $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddGroupOwner($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddGroupMember
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGroupMember $parameters
     * @return \StructType\AddGroupMemberResponse|bool
     */
    public function AddGroupMember(\StructType\AddGroupMember $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddGroupMember($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddAttributeToGUMUserResponse|\StructType\AddDelegatedOwnerResponse|\StructType\AddFutureDateTimeToGUMUserResponse|\StructType\AddGroupMemberResponse|\StructType\AddGroupOwnerResponse|\StructType\AddPreferredLanguageToGUMUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
