<?php

namespace EnumType;

/**
 * This class stands for Status_Codes EnumType
 * @subpackage Enumerations
 */
class Status_Codes
{
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Constant for value 'NotAuthenticated'
     * @return string 'NotAuthenticated'
     */
    const VALUE_NOT_AUTHENTICATED = 'NotAuthenticated';
    /**
     * Constant for value 'UserNotFound'
     * @return string 'UserNotFound'
     */
    const VALUE_USER_NOT_FOUND = 'UserNotFound';
    /**
     * Constant for value 'DuplicateUser'
     * @return string 'DuplicateUser'
     */
    const VALUE_DUPLICATE_USER = 'DuplicateUser';
    /**
     * Constant for value 'MissingRequiredField'
     * @return string 'MissingRequiredField'
     */
    const VALUE_MISSING_REQUIRED_FIELD = 'MissingRequiredField';
    /**
     * Constant for value 'DataDoesNotMeetRequirements'
     * @return string 'DataDoesNotMeetRequirements'
     */
    const VALUE_DATA_DOES_NOT_MEET_REQUIREMENTS = 'DataDoesNotMeetRequirements';
    /**
     * Constant for value 'DataDoesNotMeetMinimumOrMaximumLength'
     * @return string 'DataDoesNotMeetMinimumOrMaximumLength'
     */
    const VALUE_DATA_DOES_NOT_MEET_MINIMUM_OR_MAXIMUM_LENGTH = 'DataDoesNotMeetMinimumOrMaximumLength';
    /**
     * Constant for value 'Fail'
     * @return string 'Fail'
     */
    const VALUE_FAIL = 'Fail';
    /**
     * Constant for value 'InvalidTerritory'
     * @return string 'InvalidTerritory'
     */
    const VALUE_INVALID_TERRITORY = 'InvalidTerritory';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_NOT_AUTHENTICATED
     * @uses self::VALUE_USER_NOT_FOUND
     * @uses self::VALUE_DUPLICATE_USER
     * @uses self::VALUE_MISSING_REQUIRED_FIELD
     * @uses self::VALUE_DATA_DOES_NOT_MEET_REQUIREMENTS
     * @uses self::VALUE_DATA_DOES_NOT_MEET_MINIMUM_OR_MAXIMUM_LENGTH
     * @uses self::VALUE_FAIL
     * @uses self::VALUE_INVALID_TERRITORY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUCCESS,
            self::VALUE_NOT_AUTHENTICATED,
            self::VALUE_USER_NOT_FOUND,
            self::VALUE_DUPLICATE_USER,
            self::VALUE_MISSING_REQUIRED_FIELD,
            self::VALUE_DATA_DOES_NOT_MEET_REQUIREMENTS,
            self::VALUE_DATA_DOES_NOT_MEET_MINIMUM_OR_MAXIMUM_LENGTH,
            self::VALUE_FAIL,
            self::VALUE_INVALID_TERRITORY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
