<?php

namespace EnumType;

/**
 * This class stands for Languages EnumType
 * @subpackage Enumerations
 */
class Languages
{
    /**
     * Constant for value 'English'
     * @return string 'English'
     */
    const VALUE_ENGLISH = 'English';
    /**
     * Constant for value 'Spanish'
     * @return string 'Spanish'
     */
    const VALUE_SPANISH = 'Spanish';
    /**
     * Constant for value 'German'
     * @return string 'German'
     */
    const VALUE_GERMAN = 'German';
    /**
     * Constant for value 'Chinese_Simple'
     * @return string 'Chinese_Simple'
     */
    const VALUE_CHINESE_SIMPLE = 'Chinese_Simple';
    /**
     * Constant for value 'Chinese_Traditional'
     * @return string 'Chinese_Traditional'
     */
    const VALUE_CHINESE_TRADITIONAL = 'Chinese_Traditional';
    /**
     * Constant for value 'French'
     * @return string 'French'
     */
    const VALUE_FRENCH = 'French';
    /**
     * Constant for value 'Portuguese'
     * @return string 'Portuguese'
     */
    const VALUE_PORTUGUESE = 'Portuguese';
    /**
     * Constant for value 'Korean'
     * @return string 'Korean'
     */
    const VALUE_KOREAN = 'Korean';
    /**
     * Constant for value 'Italian'
     * @return string 'Italian'
     */
    const VALUE_ITALIAN = 'Italian';
    /**
     * Constant for value 'Danish'
     * @return string 'Danish'
     */
    const VALUE_DANISH = 'Danish';
    /**
     * Constant for value 'Dutch'
     * @return string 'Dutch'
     */
    const VALUE_DUTCH = 'Dutch';
    /**
     * Constant for value 'Japanese'
     * @return string 'Japanese'
     */
    const VALUE_JAPANESE = 'Japanese';
    /**
     * Constant for value 'Polish'
     * @return string 'Polish'
     */
    const VALUE_POLISH = 'Polish';
    /**
     * Constant for value 'Swedish'
     * @return string 'Swedish'
     */
    const VALUE_SWEDISH = 'Swedish';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENGLISH
     * @uses self::VALUE_SPANISH
     * @uses self::VALUE_GERMAN
     * @uses self::VALUE_CHINESE_SIMPLE
     * @uses self::VALUE_CHINESE_TRADITIONAL
     * @uses self::VALUE_FRENCH
     * @uses self::VALUE_PORTUGUESE
     * @uses self::VALUE_KOREAN
     * @uses self::VALUE_ITALIAN
     * @uses self::VALUE_DANISH
     * @uses self::VALUE_DUTCH
     * @uses self::VALUE_JAPANESE
     * @uses self::VALUE_POLISH
     * @uses self::VALUE_SWEDISH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENGLISH,
            self::VALUE_SPANISH,
            self::VALUE_GERMAN,
            self::VALUE_CHINESE_SIMPLE,
            self::VALUE_CHINESE_TRADITIONAL,
            self::VALUE_FRENCH,
            self::VALUE_PORTUGUESE,
            self::VALUE_KOREAN,
            self::VALUE_ITALIAN,
            self::VALUE_DANISH,
            self::VALUE_DUTCH,
            self::VALUE_JAPANESE,
            self::VALUE_POLISH,
            self::VALUE_SWEDISH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
