<?php

namespace EnumType;

/**
 * This class stands for GroupAttributeNames EnumType
 * @subpackage Enumerations
 */
class GroupAttributeNames
{
    /**
     * Constant for value 'AccountName'
     * @return string 'AccountName'
     */
    const VALUE_ACCOUNT_NAME = 'AccountName';
    /**
     * Constant for value 'DisplayName'
     * @return string 'DisplayName'
     */
    const VALUE_DISPLAY_NAME = 'DisplayName';
    /**
     * Constant for value 'Description'
     * @return string 'Description'
     */
    const VALUE_DESCRIPTION = 'Description';
    /**
     * Constant for value 'DisplayedOwner'
     * @return string 'DisplayedOwner'
     */
    const VALUE_DISPLAYED_OWNER = 'DisplayedOwner';
    /**
     * Constant for value 'Domain'
     * @return string 'Domain'
     */
    const VALUE_DOMAIN = 'Domain';
    /**
     * Constant for value 'Members'
     * @return string 'Members'
     */
    const VALUE_MEMBERS = 'Members';
    /**
     * Constant for value 'Owners'
     * @return string 'Owners'
     */
    const VALUE_OWNERS = 'Owners';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_NAME
     * @uses self::VALUE_DISPLAY_NAME
     * @uses self::VALUE_DESCRIPTION
     * @uses self::VALUE_DISPLAYED_OWNER
     * @uses self::VALUE_DOMAIN
     * @uses self::VALUE_MEMBERS
     * @uses self::VALUE_OWNERS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_NAME,
            self::VALUE_DISPLAY_NAME,
            self::VALUE_DESCRIPTION,
            self::VALUE_DISPLAYED_OWNER,
            self::VALUE_DOMAIN,
            self::VALUE_MEMBERS,
            self::VALUE_OWNERS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
