<?php

namespace EnumType;

/**
 * This class stands for FutureTimes EnumType
 * @subpackage Enumerations
 */
class FutureTimes
{
    /**
     * Constant for value 'TwoAMGMT'
     * @return string 'TwoAMGMT'
     */
    const VALUE_TWO_AMGMT = 'TwoAMGMT';
    /**
     * Constant for value 'EightAMGMT'
     * @return string 'EightAMGMT'
     */
    const VALUE_EIGHT_AMGMT = 'EightAMGMT';
    /**
     * Constant for value 'TwoPMGMT'
     * @return string 'TwoPMGMT'
     */
    const VALUE_TWO_PMGMT = 'TwoPMGMT';
    /**
     * Constant for value 'EightPMGMT'
     * @return string 'EightPMGMT'
     */
    const VALUE_EIGHT_PMGMT = 'EightPMGMT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TWO_AMGMT
     * @uses self::VALUE_EIGHT_AMGMT
     * @uses self::VALUE_TWO_PMGMT
     * @uses self::VALUE_EIGHT_PMGMT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TWO_AMGMT,
            self::VALUE_EIGHT_AMGMT,
            self::VALUE_TWO_PMGMT,
            self::VALUE_EIGHT_PMGMT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
