<?php

namespace EnumType;

/**
 * This class stands for AttributeNames EnumType
 * @subpackage Enumerations
 */
class AttributeNames
{
    /**
     * Constant for value 'FirstName'
     * @return string 'FirstName'
     */
    const VALUE_FIRST_NAME = 'FirstName';
    /**
     * Constant for value 'LastName'
     * @return string 'LastName'
     */
    const VALUE_LAST_NAME = 'LastName';
    /**
     * Constant for value 'Email'
     * @return string 'Email'
     */
    const VALUE_EMAIL = 'Email';
    /**
     * Constant for value 'Organisation'
     * @return string 'Organisation'
     */
    const VALUE_ORGANISATION = 'Organisation';
    /**
     * Constant for value 'Territory'
     * @return string 'Territory'
     */
    const VALUE_TERRITORY = 'Territory';
    /**
     * Constant for value 'CountryDialingCode'
     * @return string 'CountryDialingCode'
     */
    const VALUE_COUNTRY_DIALING_CODE = 'CountryDialingCode';
    /**
     * Constant for value 'MobilePhone'
     * @return string 'MobilePhone'
     */
    const VALUE_MOBILE_PHONE = 'MobilePhone';
    /**
     * Constant for value 'DelegatedOwner'
     * @return string 'DelegatedOwner'
     */
    const VALUE_DELEGATED_OWNER = 'DelegatedOwner';
    /**
     * Constant for value 'Application'
     * @return string 'Application'
     */
    const VALUE_APPLICATION = 'Application';
    /**
     * Constant for value 'AssuranceLevel'
     * @return string 'AssuranceLevel'
     */
    const VALUE_ASSURANCE_LEVEL = 'AssuranceLevel';
    /**
     * Constant for value 'UpdateAssuranceLevel'
     * @return string 'UpdateAssuranceLevel'
     */
    const VALUE_UPDATE_ASSURANCE_LEVEL = 'UpdateAssuranceLevel';
    /**
     * Constant for value 'FutureDate'
     * @return string 'FutureDate'
     */
    const VALUE_FUTURE_DATE = 'FutureDate';
    /**
     * Constant for value 'FutureTime'
     * @return string 'FutureTime'
     */
    const VALUE_FUTURE_TIME = 'FutureTime';
    /**
     * Constant for value 'LockAccount'
     * @return string 'LockAccount'
     */
    const VALUE_LOCK_ACCOUNT = 'LockAccount';
    /**
     * Constant for value 'pwcPreferredLanguage'
     * @return string 'pwcPreferredLanguage'
     */
    const VALUE_PWC_PREFERRED_LANGUAGE = 'pwcPreferredLanguage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIRST_NAME
     * @uses self::VALUE_LAST_NAME
     * @uses self::VALUE_EMAIL
     * @uses self::VALUE_ORGANISATION
     * @uses self::VALUE_TERRITORY
     * @uses self::VALUE_COUNTRY_DIALING_CODE
     * @uses self::VALUE_MOBILE_PHONE
     * @uses self::VALUE_DELEGATED_OWNER
     * @uses self::VALUE_APPLICATION
     * @uses self::VALUE_ASSURANCE_LEVEL
     * @uses self::VALUE_UPDATE_ASSURANCE_LEVEL
     * @uses self::VALUE_FUTURE_DATE
     * @uses self::VALUE_FUTURE_TIME
     * @uses self::VALUE_LOCK_ACCOUNT
     * @uses self::VALUE_PWC_PREFERRED_LANGUAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIRST_NAME,
            self::VALUE_LAST_NAME,
            self::VALUE_EMAIL,
            self::VALUE_ORGANISATION,
            self::VALUE_TERRITORY,
            self::VALUE_COUNTRY_DIALING_CODE,
            self::VALUE_MOBILE_PHONE,
            self::VALUE_DELEGATED_OWNER,
            self::VALUE_APPLICATION,
            self::VALUE_ASSURANCE_LEVEL,
            self::VALUE_UPDATE_ASSURANCE_LEVEL,
            self::VALUE_FUTURE_DATE,
            self::VALUE_FUTURE_TIME,
            self::VALUE_LOCK_ACCOUNT,
            self::VALUE_PWC_PREFERRED_LANGUAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
