<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveGroupMember StructType
 * @subpackage Structs
 */
class RemoveGroupMember extends AbstractStructBase
{
    /**
     * The groupGuid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $groupGuid;
    /**
     * The guidsToRemove
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $guidsToRemove;
    /**
     * The myCred
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Credential
     */
    public $myCred;
    /**
     * Constructor method for RemoveGroupMember
     * @uses RemoveGroupMember::setGroupGuid()
     * @uses RemoveGroupMember::setGuidsToRemove()
     * @uses RemoveGroupMember::setMyCred()
     * @param string $groupGuid
     * @param \ArrayType\ArrayOfString $guidsToRemove
     * @param \StructType\Credential $myCred
     */
    public function __construct($groupGuid = null, \ArrayType\ArrayOfString $guidsToRemove = null, \StructType\Credential $myCred = null)
    {
        $this
            ->setGroupGuid($groupGuid)
            ->setGuidsToRemove($guidsToRemove)
            ->setMyCred($myCred);
    }
    /**
     * Get groupGuid value
     * @return string|null
     */
    public function getGroupGuid()
    {
        return $this->groupGuid;
    }
    /**
     * Set groupGuid value
     * @param string $groupGuid
     * @return \StructType\RemoveGroupMember
     */
    public function setGroupGuid($groupGuid = null)
    {
        // validation for constraint: string
        if (!is_null($groupGuid) && !is_string($groupGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupGuid)), __LINE__);
        }
        $this->groupGuid = $groupGuid;
        return $this;
    }
    /**
     * Get guidsToRemove value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getGuidsToRemove()
    {
        return $this->guidsToRemove;
    }
    /**
     * Set guidsToRemove value
     * @param \ArrayType\ArrayOfString $guidsToRemove
     * @return \StructType\RemoveGroupMember
     */
    public function setGuidsToRemove(\ArrayType\ArrayOfString $guidsToRemove = null)
    {
        $this->guidsToRemove = $guidsToRemove;
        return $this;
    }
    /**
     * Get myCred value
     * @return \StructType\Credential|null
     */
    public function getMyCred()
    {
        return $this->myCred;
    }
    /**
     * Set myCred value
     * @param \StructType\Credential $myCred
     * @return \StructType\RemoveGroupMember
     */
    public function setMyCred(\StructType\Credential $myCred = null)
    {
        $this->myCred = $myCred;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveGroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
