<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddPreferredLanguageToGUMUser StructType
 * @subpackage Structs
 */
class AddPreferredLanguageToGUMUser extends AbstractStructBase
{
    /**
     * The preferredLanguage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $preferredLanguage;
    /**
     * The gumUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GUMUser
     */
    public $gumUser;
    /**
     * Constructor method for AddPreferredLanguageToGUMUser
     * @uses AddPreferredLanguageToGUMUser::setPreferredLanguage()
     * @uses AddPreferredLanguageToGUMUser::setGumUser()
     * @param string $preferredLanguage
     * @param \StructType\GUMUser $gumUser
     */
    public function __construct($preferredLanguage = null, \StructType\GUMUser $gumUser = null)
    {
        $this
            ->setPreferredLanguage($preferredLanguage)
            ->setGumUser($gumUser);
    }
    /**
     * Get preferredLanguage value
     * @return string
     */
    public function getPreferredLanguage()
    {
        return $this->preferredLanguage;
    }
    /**
     * Set preferredLanguage value
     * @uses \EnumType\Languages::valueIsValid()
     * @uses \EnumType\Languages::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferredLanguage
     * @return \StructType\AddPreferredLanguageToGUMUser
     */
    public function setPreferredLanguage($preferredLanguage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Languages::valueIsValid($preferredLanguage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferredLanguage, implode(', ', \EnumType\Languages::getValidValues())), __LINE__);
        }
        $this->preferredLanguage = $preferredLanguage;
        return $this;
    }
    /**
     * Get gumUser value
     * @return \StructType\GUMUser|null
     */
    public function getGumUser()
    {
        return $this->gumUser;
    }
    /**
     * Set gumUser value
     * @param \StructType\GUMUser $gumUser
     * @return \StructType\AddPreferredLanguageToGUMUser
     */
    public function setGumUser(\StructType\GUMUser $gumUser = null)
    {
        $this->gumUser = $gumUser;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddPreferredLanguageToGUMUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
