<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddGroupOwner StructType
 * @subpackage Structs
 */
class AddGroupOwner extends AbstractStructBase
{
    /**
     * The groupGuid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $groupGuid;
    /**
     * The guidsToAdd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $guidsToAdd;
    /**
     * The myCred
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Credential
     */
    public $myCred;
    /**
     * Constructor method for AddGroupOwner
     * @uses AddGroupOwner::setGroupGuid()
     * @uses AddGroupOwner::setGuidsToAdd()
     * @uses AddGroupOwner::setMyCred()
     * @param string $groupGuid
     * @param \ArrayType\ArrayOfString $guidsToAdd
     * @param \StructType\Credential $myCred
     */
    public function __construct($groupGuid = null, \ArrayType\ArrayOfString $guidsToAdd = null, \StructType\Credential $myCred = null)
    {
        $this
            ->setGroupGuid($groupGuid)
            ->setGuidsToAdd($guidsToAdd)
            ->setMyCred($myCred);
    }
    /**
     * Get groupGuid value
     * @return string|null
     */
    public function getGroupGuid()
    {
        return $this->groupGuid;
    }
    /**
     * Set groupGuid value
     * @param string $groupGuid
     * @return \StructType\AddGroupOwner
     */
    public function setGroupGuid($groupGuid = null)
    {
        // validation for constraint: string
        if (!is_null($groupGuid) && !is_string($groupGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupGuid)), __LINE__);
        }
        $this->groupGuid = $groupGuid;
        return $this;
    }
    /**
     * Get guidsToAdd value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getGuidsToAdd()
    {
        return $this->guidsToAdd;
    }
    /**
     * Set guidsToAdd value
     * @param \ArrayType\ArrayOfString $guidsToAdd
     * @return \StructType\AddGroupOwner
     */
    public function setGuidsToAdd(\ArrayType\ArrayOfString $guidsToAdd = null)
    {
        $this->guidsToAdd = $guidsToAdd;
        return $this;
    }
    /**
     * Get myCred value
     * @return \StructType\Credential|null
     */
    public function getMyCred()
    {
        return $this->myCred;
    }
    /**
     * Set myCred value
     * @param \StructType\Credential $myCred
     * @return \StructType\AddGroupOwner
     */
    public function setMyCred(\StructType\Credential $myCred = null)
    {
        $this->myCred = $myCred;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddGroupOwner
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
