<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddFutureDateTimeToGUMUser StructType
 * @subpackage Structs
 */
class AddFutureDateTimeToGUMUser extends AbstractStructBase
{
    /**
     * The futureTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $futureTime;
    /**
     * The gumUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GUMUser
     */
    public $gumUser;
    /**
     * The futureDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $futureDate;
    /**
     * Constructor method for AddFutureDateTimeToGUMUser
     * @uses AddFutureDateTimeToGUMUser::setFutureTime()
     * @uses AddFutureDateTimeToGUMUser::setGumUser()
     * @uses AddFutureDateTimeToGUMUser::setFutureDate()
     * @param string $futureTime
     * @param \StructType\GUMUser $gumUser
     * @param string $futureDate
     */
    public function __construct($futureTime = null, \StructType\GUMUser $gumUser = null, $futureDate = null)
    {
        $this
            ->setFutureTime($futureTime)
            ->setGumUser($gumUser)
            ->setFutureDate($futureDate);
    }
    /**
     * Get futureTime value
     * @return string
     */
    public function getFutureTime()
    {
        return $this->futureTime;
    }
    /**
     * Set futureTime value
     * @uses \EnumType\FutureTimes::valueIsValid()
     * @uses \EnumType\FutureTimes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $futureTime
     * @return \StructType\AddFutureDateTimeToGUMUser
     */
    public function setFutureTime($futureTime = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FutureTimes::valueIsValid($futureTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $futureTime, implode(', ', \EnumType\FutureTimes::getValidValues())), __LINE__);
        }
        $this->futureTime = $futureTime;
        return $this;
    }
    /**
     * Get gumUser value
     * @return \StructType\GUMUser|null
     */
    public function getGumUser()
    {
        return $this->gumUser;
    }
    /**
     * Set gumUser value
     * @param \StructType\GUMUser $gumUser
     * @return \StructType\AddFutureDateTimeToGUMUser
     */
    public function setGumUser(\StructType\GUMUser $gumUser = null)
    {
        $this->gumUser = $gumUser;
        return $this;
    }
    /**
     * Get futureDate value
     * @return string|null
     */
    public function getFutureDate()
    {
        return $this->futureDate;
    }
    /**
     * Set futureDate value
     * @param string $futureDate
     * @return \StructType\AddFutureDateTimeToGUMUser
     */
    public function setFutureDate($futureDate = null)
    {
        // validation for constraint: string
        if (!is_null($futureDate) && !is_string($futureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($futureDate)), __LINE__);
        }
        $this->futureDate = $futureDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddFutureDateTimeToGUMUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
