<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAttributeToGUMUser StructType
 * @subpackage Structs
 */
class AddAttributeToGUMUser extends AbstractStructBase
{
    /**
     * The attrName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $attrName;
    /**
     * The gumUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GUMUser
     */
    public $gumUser;
    /**
     * The AttributeValues
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnyType
     */
    public $AttributeValues;
    /**
     * Constructor method for AddAttributeToGUMUser
     * @uses AddAttributeToGUMUser::setAttrName()
     * @uses AddAttributeToGUMUser::setGumUser()
     * @uses AddAttributeToGUMUser::setAttributeValues()
     * @param string $attrName
     * @param \StructType\GUMUser $gumUser
     * @param \ArrayType\ArrayOfAnyType $attributeValues
     */
    public function __construct($attrName = null, \StructType\GUMUser $gumUser = null, \ArrayType\ArrayOfAnyType $attributeValues = null)
    {
        $this
            ->setAttrName($attrName)
            ->setGumUser($gumUser)
            ->setAttributeValues($attributeValues);
    }
    /**
     * Get attrName value
     * @return string
     */
    public function getAttrName()
    {
        return $this->attrName;
    }
    /**
     * Set attrName value
     * @uses \EnumType\AttributeNames::valueIsValid()
     * @uses \EnumType\AttributeNames::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attrName
     * @return \StructType\AddAttributeToGUMUser
     */
    public function setAttrName($attrName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AttributeNames::valueIsValid($attrName)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $attrName, implode(', ', \EnumType\AttributeNames::getValidValues())), __LINE__);
        }
        $this->attrName = $attrName;
        return $this;
    }
    /**
     * Get gumUser value
     * @return \StructType\GUMUser|null
     */
    public function getGumUser()
    {
        return $this->gumUser;
    }
    /**
     * Set gumUser value
     * @param \StructType\GUMUser $gumUser
     * @return \StructType\AddAttributeToGUMUser
     */
    public function setGumUser(\StructType\GUMUser $gumUser = null)
    {
        $this->gumUser = $gumUser;
        return $this;
    }
    /**
     * Get AttributeValues value
     * @return \ArrayType\ArrayOfAnyType|null
     */
    public function getAttributeValues()
    {
        return $this->AttributeValues;
    }
    /**
     * Set AttributeValues value
     * @param \ArrayType\ArrayOfAnyType $attributeValues
     * @return \StructType\AddAttributeToGUMUser
     */
    public function setAttributeValues(\ArrayType\ArrayOfAnyType $attributeValues = null)
    {
        $this->AttributeValues = $attributeValues;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddAttributeToGUMUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
