<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Validate ServiceType
 * @subpackage Services
 */
class Validate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ValidateUserByEmail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ValidateUserByEmail $parameters
     * @return \StructType\ValidateUserByEmailResponse|bool
     */
    public function ValidateUserByEmail(\StructType\ValidateUserByEmail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ValidateUserByEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ValidateUserByGuid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ValidateUserByGuid $parameters
     * @return \StructType\ValidateUserByGuidResponse|bool
     */
    public function ValidateUserByGuid(\StructType\ValidateUserByGuid $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ValidateUserByGuid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ValidateGroupByGuid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ValidateGroupByGuid $parameters
     * @return \StructType\ValidateGroupByGuidResponse|bool
     */
    public function ValidateGroupByGuid(\StructType\ValidateGroupByGuid $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ValidateGroupByGuid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ValidateGroupByGuidResponse|\StructType\ValidateUserByEmailResponse|\StructType\ValidateUserByGuidResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
