<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateUser $parameters
     * @return \StructType\UpdateUserResponse|bool
     */
    public function UpdateUser(\StructType\UpdateUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateAssuranceLevel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAssuranceLevel $parameters
     * @return \StructType\UpdateAssuranceLevelResponse|bool
     */
    public function UpdateAssuranceLevel(\StructType\UpdateAssuranceLevel $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateAssuranceLevel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateGroupDisplayedOwner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGroupDisplayedOwner $parameters
     * @return \StructType\UpdateGroupDisplayedOwnerResponse|bool
     */
    public function UpdateGroupDisplayedOwner(\StructType\UpdateGroupDisplayedOwner $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateGroupDisplayedOwner($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGroup $parameters
     * @return \StructType\UpdateGroupResponse|bool
     */
    public function UpdateGroup(\StructType\UpdateGroup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateAssuranceLevelResponse|\StructType\UpdateGroupDisplayedOwnerResponse|\StructType\UpdateGroupResponse|\StructType\UpdateUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
