<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RemoveDelegatedOwner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveDelegatedOwner $parameters
     * @return \StructType\RemoveDelegatedOwnerResponse|bool
     */
    public function RemoveDelegatedOwner(\StructType\RemoveDelegatedOwner $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveDelegatedOwner($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveGroupOwner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveGroupOwner $parameters
     * @return \StructType\RemoveGroupOwnerResponse|bool
     */
    public function RemoveGroupOwner(\StructType\RemoveGroupOwner $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveGroupOwner($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveGroupMember
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveGroupMember $parameters
     * @return \StructType\RemoveGroupMemberResponse|bool
     */
    public function RemoveGroupMember(\StructType\RemoveGroupMember $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveGroupMember($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RemoveDelegatedOwnerResponse|\StructType\RemoveGroupMemberResponse|\StructType\RemoveGroupOwnerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
