<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Consultar ServiceType
 */
$consultar = new \ServiceType\Consultar($options);
/**
 * Sample call for Consultar operation/method
 */
if ($consultar->Consultar(new \StructType\Consultar()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Samples for Pagar ServiceType
 */
$pagar = new \ServiceType\Pagar($options);
/**
 * Sample call for Pagar operation/method
 */
if ($pagar->Pagar(new \StructType\Pagar()) !== false) {
    print_r($pagar->getResult());
} else {
    print_r($pagar->getLastError());
}
/**
 * Samples for Reversar ServiceType
 */
$reversar = new \ServiceType\Reversar($options);
/**
 * Sample call for Reversar operation/method
 */
if ($reversar->Reversar(new \StructType\Reversar()) !== false) {
    print_r($reversar->getResult());
} else {
    print_r($reversar->getLastError());
}
