<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for systemPaymentInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Payment information concerning system payments.
 * @subpackage Structs
 */
class SystemPaymentInfo extends AbstractStructBase
{
    /**
     * The shopperBankAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\ShopperBankAccount
     */
    public $shopperBankAccount;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for systemPaymentInfo
     * @uses SystemPaymentInfo::setShopperBankAccount()
     * @uses SystemPaymentInfo::setAny()
     * @param \Models\Docdata\StructType\ShopperBankAccount $shopperBankAccount
     * @param \DOMDocument $any
     */
    public function __construct(\Models\Docdata\StructType\ShopperBankAccount $shopperBankAccount = null, \DOMDocument $any = null)
    {
        $this
            ->setShopperBankAccount($shopperBankAccount)
            ->setAny($any);
    }
    /**
     * Get shopperBankAccount value
     * @return \Models\Docdata\StructType\ShopperBankAccount|null
     */
    public function getShopperBankAccount()
    {
        return $this->shopperBankAccount;
    }
    /**
     * Set shopperBankAccount value
     * @param \Models\Docdata\StructType\ShopperBankAccount $shopperBankAccount
     * @return \Models\Docdata\StructType\SystemPaymentInfo
     */
    public function setShopperBankAccount(\Models\Docdata\StructType\ShopperBankAccount $shopperBankAccount = null)
    {
        $this->shopperBankAccount = $shopperBankAccount;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\SystemPaymentInfo::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\SystemPaymentInfo
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\SystemPaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
