<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for statusReport StructType
 * @subpackage Structs
 */
class StatusReport extends AbstractStructBase
{
    /**
     * The approximateTotals
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\ApproximateTotals
     */
    public $approximateTotals;
    /**
     * The payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\Payment[]
     */
    public $payment;
    /**
     * The consideredSafe
     * Meta informations extracted from the WSDL
     * - documentation: Contains considered safe details. When the system is unable to determine if the order is considered safe, this element is omitted.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\ConsideredSafe
     */
    public $consideredSafe;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for statusReport
     * @uses StatusReport::setApproximateTotals()
     * @uses StatusReport::setPayment()
     * @uses StatusReport::setConsideredSafe()
     * @uses StatusReport::setAny()
     * @param \Models\Docdata\StructType\ApproximateTotals $approximateTotals
     * @param \Models\Docdata\StructType\Payment[] $payment
     * @param \Models\Docdata\StructType\ConsideredSafe $consideredSafe
     * @param \DOMDocument $any
     */
    public function __construct(\Models\Docdata\StructType\ApproximateTotals $approximateTotals = null, array $payment = array(), \Models\Docdata\StructType\ConsideredSafe $consideredSafe = null, \DOMDocument $any = null)
    {
        $this
            ->setApproximateTotals($approximateTotals)
            ->setPayment($payment)
            ->setConsideredSafe($consideredSafe)
            ->setAny($any);
    }
    /**
     * Get approximateTotals value
     * @return \Models\Docdata\StructType\ApproximateTotals
     */
    public function getApproximateTotals()
    {
        return $this->approximateTotals;
    }
    /**
     * Set approximateTotals value
     * @param \Models\Docdata\StructType\ApproximateTotals $approximateTotals
     * @return \Models\Docdata\StructType\StatusReport
     */
    public function setApproximateTotals(\Models\Docdata\StructType\ApproximateTotals $approximateTotals = null)
    {
        $this->approximateTotals = $approximateTotals;
        return $this;
    }
    /**
     * Get payment value
     * @return \Models\Docdata\StructType\Payment[]|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @throws \InvalidArgumentException
     * @param \Models\Docdata\StructType\Payment[] $payment
     * @return \Models\Docdata\StructType\StatusReport
     */
    public function setPayment(array $payment = array())
    {
        foreach ($payment as $statusReportPaymentItem) {
            // validation for constraint: itemType
            if (!$statusReportPaymentItem instanceof \Models\Docdata\StructType\Payment) {
                throw new \InvalidArgumentException(sprintf('The payment property can only contain items of \Models\Docdata\StructType\Payment, "%s" given', is_object($statusReportPaymentItem) ? get_class($statusReportPaymentItem) : gettype($statusReportPaymentItem)), __LINE__);
            }
        }
        $this->payment = $payment;
        return $this;
    }
    /**
     * Add item to payment value
     * @throws \InvalidArgumentException
     * @param \Models\Docdata\StructType\Payment $item
     * @return \Models\Docdata\StructType\StatusReport
     */
    public function addToPayment(\Models\Docdata\StructType\Payment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Models\Docdata\StructType\Payment) {
            throw new \InvalidArgumentException(sprintf('The payment property can only contain items of \Models\Docdata\StructType\Payment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->payment[] = $item;
        return $this;
    }
    /**
     * Get consideredSafe value
     * @return \Models\Docdata\StructType\ConsideredSafe|null
     */
    public function getConsideredSafe()
    {
        return $this->consideredSafe;
    }
    /**
     * Set consideredSafe value
     * @param \Models\Docdata\StructType\ConsideredSafe $consideredSafe
     * @return \Models\Docdata\StructType\StatusReport
     */
    public function setConsideredSafe(\Models\Docdata\StructType\ConsideredSafe $consideredSafe = null)
    {
        $this->consideredSafe = $consideredSafe;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\StatusReport::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\StatusReport
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\StatusReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
