<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for startResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response to a start request.
 * @subpackage Structs
 */
class StartResponse extends AbstractStructBase
{
    /**
     * The startErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\StartErrors
     */
    public $startErrors;
    /**
     * The startSuccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\StartSuccess
     */
    public $startSuccess;
    /**
     * The ddpXsdVersion
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $ddpXsdVersion;
    /**
     * Constructor method for startResponse
     * @uses StartResponse::setStartErrors()
     * @uses StartResponse::setStartSuccess()
     * @uses StartResponse::setDdpXsdVersion()
     * @param \Models\Docdata\StructType\StartErrors $startErrors
     * @param \Models\Docdata\StructType\StartSuccess $startSuccess
     * @param string $ddpXsdVersion
     */
    public function __construct(\Models\Docdata\StructType\StartErrors $startErrors = null, \Models\Docdata\StructType\StartSuccess $startSuccess = null, $ddpXsdVersion = null)
    {
        $this
            ->setStartErrors($startErrors)
            ->setStartSuccess($startSuccess)
            ->setDdpXsdVersion($ddpXsdVersion);
    }
    /**
     * Get startErrors value
     * @return \Models\Docdata\StructType\StartErrors
     */
    public function getStartErrors()
    {
        return $this->startErrors;
    }
    /**
     * Set startErrors value
     * @param \Models\Docdata\StructType\StartErrors $startErrors
     * @return \Models\Docdata\StructType\StartResponse
     */
    public function setStartErrors(\Models\Docdata\StructType\StartErrors $startErrors = null)
    {
        $this->startErrors = $startErrors;
        return $this;
    }
    /**
     * Get startSuccess value
     * @return \Models\Docdata\StructType\StartSuccess
     */
    public function getStartSuccess()
    {
        return $this->startSuccess;
    }
    /**
     * Set startSuccess value
     * @param \Models\Docdata\StructType\StartSuccess $startSuccess
     * @return \Models\Docdata\StructType\StartResponse
     */
    public function setStartSuccess(\Models\Docdata\StructType\StartSuccess $startSuccess = null)
    {
        $this->startSuccess = $startSuccess;
        return $this;
    }
    /**
     * Get ddpXsdVersion value
     * @return string
     */
    public function getDdpXsdVersion()
    {
        return $this->ddpXsdVersion;
    }
    /**
     * Set ddpXsdVersion value
     * @param string $ddpXsdVersion
     * @return \Models\Docdata\StructType\StartResponse
     */
    public function setDdpXsdVersion($ddpXsdVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) > 35) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($ddpXsdVersion) ? strlen($ddpXsdVersion) : count($ddpXsdVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) < 1) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ddpXsdVersion) && !is_string($ddpXsdVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ddpXsdVersion)), __LINE__);
        }
        $this->ddpXsdVersion = $ddpXsdVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\StartResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
