<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shopperBankAccount StructType
 * Meta informations extracted from the WSDL
 * - documentation: Shopper bank account information.
 * @subpackage Structs
 */
class ShopperBankAccount extends AbstractStructBase
{
    /**
     * The iban
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1 | 1
     * - minOccurs: 0 | 1
     * - maxLength: 34
     * - minLength: 15
     * - type: ddp:iban
     * @var string
     */
    public $iban;
    /**
     * The bic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1 | 1
     * - minOccurs: 0 | 0
     * - maxLength: 11
     * - minLength: 8
     * - type: ddp:bic
     * @var string
     */
    public $bic;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for shopperBankAccount
     * @uses ShopperBankAccount::setIban()
     * @uses ShopperBankAccount::setBic()
     * @uses ShopperBankAccount::setAny()
     * @param string $iban
     * @param string $bic
     * @param \DOMDocument $any
     */
    public function __construct($iban = null, $bic = null, \DOMDocument $any = null)
    {
        $this
            ->setIban($iban)
            ->setBic($bic)
            ->setAny($any);
    }
    /**
     * Get iban value
     * @return string
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \Models\Docdata\StructType\ShopperBankAccount
     */
    public function setIban($iban = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iban) && strlen($iban) > 34) || (is_array($iban) && count($iban) > 34)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 34 element(s) or a scalar of 34 character(s) at most, "%d" length given', is_scalar($iban) ? strlen($iban) : count($iban)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iban) && strlen($iban) < 15) || (is_array($iban) && count($iban) < 15)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
    /**
     * Get bic value
     * @return string
     */
    public function getBic()
    {
        return $this->bic;
    }
    /**
     * Set bic value
     * @param string $bic
     * @return \Models\Docdata\StructType\ShopperBankAccount
     */
    public function setBic($bic = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bic) && strlen($bic) > 11) || (is_array($bic) && count($bic) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($bic) ? strlen($bic) : count($bic)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bic) && strlen($bic) < 8) || (is_array($bic) && count($bic) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bic) && !is_string($bic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bic)), __LINE__);
        }
        $this->bic = $bic;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\ShopperBankAccount::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\ShopperBankAccount
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\ShopperBankAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
