<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for proceedRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Allows to request proceeding a payment that was started earlier.
 * @subpackage Structs
 */
class ProceedRequest extends AbstractStructBase
{
    /**
     * The merchant
     * Meta informations extracted from the WSDL
     * - documentation: Merchant's credentials.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Merchant
     */
    public $merchant;
    /**
     * The paymentId
     * Meta informations extracted from the WSDL
     * - documentation: The ID of the payment that should be proceeded. | The payment ID with check digit as generated by the payment system.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $paymentId;
    /**
     * The threeDomainSecureAuthenticationResult
     * Meta informations extracted from the WSDL
     * - documentation: 3DS Authentication result data. (tag name cannot start with a number)
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\ThreeDomainSecureAuthenticationResult
     */
    public $threeDomainSecureAuthenticationResult;
    /**
     * The iDealAuthorizationResult
     * Meta informations extracted from the WSDL
     * - documentation: iDEAL authorization result data. No additional data is required.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\IDealAuthorizationResult
     */
    public $iDealAuthorizationResult;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - fixed: 1.3
     * - use: required
     * @var float
     */
    public $version;
    /**
     * The integrationInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\TechnicalIntegrationInfo
     */
    public $integrationInfo;
    /**
     * The testExtensibility
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Test extensibility of client implementation by returning test elements and attributes indicated by with the names and string value "_any".
     * - use: optional
     * @var bool
     */
    public $testExtensibility;
    /**
     * Constructor method for proceedRequest
     * @uses ProceedRequest::setMerchant()
     * @uses ProceedRequest::setPaymentId()
     * @uses ProceedRequest::setThreeDomainSecureAuthenticationResult()
     * @uses ProceedRequest::setIDealAuthorizationResult()
     * @uses ProceedRequest::setVersion()
     * @uses ProceedRequest::setIntegrationInfo()
     * @uses ProceedRequest::setTestExtensibility()
     * @param \Models\Docdata\StructType\Merchant $merchant
     * @param int $paymentId
     * @param \Models\Docdata\StructType\ThreeDomainSecureAuthenticationResult $threeDomainSecureAuthenticationResult
     * @param \Models\Docdata\StructType\IDealAuthorizationResult $iDealAuthorizationResult
     * @param float $version
     * @param \Models\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo
     * @param bool $testExtensibility
     */
    public function __construct(\Models\Docdata\StructType\Merchant $merchant = null, $paymentId = null, \Models\Docdata\StructType\ThreeDomainSecureAuthenticationResult $threeDomainSecureAuthenticationResult = null, \Models\Docdata\StructType\IDealAuthorizationResult $iDealAuthorizationResult = null, $version = null, \Models\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo = null, $testExtensibility = false)
    {
        $this
            ->setMerchant($merchant)
            ->setPaymentId($paymentId)
            ->setThreeDomainSecureAuthenticationResult($threeDomainSecureAuthenticationResult)
            ->setIDealAuthorizationResult($iDealAuthorizationResult)
            ->setVersion($version)
            ->setIntegrationInfo($integrationInfo)
            ->setTestExtensibility($testExtensibility);
    }
    /**
     * Get merchant value
     * @return \Models\Docdata\StructType\Merchant
     */
    public function getMerchant()
    {
        return $this->merchant;
    }
    /**
     * Set merchant value
     * @param \Models\Docdata\StructType\Merchant $merchant
     * @return \Models\Docdata\StructType\ProceedRequest
     */
    public function setMerchant(\Models\Docdata\StructType\Merchant $merchant = null)
    {
        $this->merchant = $merchant;
        return $this;
    }
    /**
     * Get paymentId value
     * @return int
     */
    public function getPaymentId()
    {
        return $this->paymentId;
    }
    /**
     * Set paymentId value
     * @param int $paymentId
     * @return \Models\Docdata\StructType\ProceedRequest
     */
    public function setPaymentId($paymentId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentId) && !is_numeric($paymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentId)), __LINE__);
        }
        $this->paymentId = $paymentId;
        return $this;
    }
    /**
     * Get threeDomainSecureAuthenticationResult value
     * @return \Models\Docdata\StructType\ThreeDomainSecureAuthenticationResult
     */
    public function getThreeDomainSecureAuthenticationResult()
    {
        return $this->threeDomainSecureAuthenticationResult;
    }
    /**
     * Set threeDomainSecureAuthenticationResult value
     * @param \Models\Docdata\StructType\ThreeDomainSecureAuthenticationResult $threeDomainSecureAuthenticationResult
     * @return \Models\Docdata\StructType\ProceedRequest
     */
    public function setThreeDomainSecureAuthenticationResult(\Models\Docdata\StructType\ThreeDomainSecureAuthenticationResult $threeDomainSecureAuthenticationResult = null)
    {
        $this->threeDomainSecureAuthenticationResult = $threeDomainSecureAuthenticationResult;
        return $this;
    }
    /**
     * Get iDealAuthorizationResult value
     * @return \Models\Docdata\StructType\IDealAuthorizationResult
     */
    public function getIDealAuthorizationResult()
    {
        return $this->iDealAuthorizationResult;
    }
    /**
     * Set iDealAuthorizationResult value
     * @param \Models\Docdata\StructType\IDealAuthorizationResult $iDealAuthorizationResult
     * @return \Models\Docdata\StructType\ProceedRequest
     */
    public function setIDealAuthorizationResult(\Models\Docdata\StructType\IDealAuthorizationResult $iDealAuthorizationResult = null)
    {
        $this->iDealAuthorizationResult = $iDealAuthorizationResult;
        return $this;
    }
    /**
     * Get version value
     * @return float
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param float $version
     * @return \Models\Docdata\StructType\ProceedRequest
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Get integrationInfo value
     * @return \Models\Docdata\StructType\TechnicalIntegrationInfo|null
     */
    public function getIntegrationInfo()
    {
        return $this->integrationInfo;
    }
    /**
     * Set integrationInfo value
     * @param \Models\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo
     * @return \Models\Docdata\StructType\ProceedRequest
     */
    public function setIntegrationInfo(\Models\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo = null)
    {
        $this->integrationInfo = $integrationInfo;
        return $this;
    }
    /**
     * Get testExtensibility value
     * @return bool|null
     */
    public function getTestExtensibility()
    {
        return $this->testExtensibility;
    }
    /**
     * Set testExtensibility value
     * @param bool $testExtensibility
     * @return \Models\Docdata\StructType\ProceedRequest
     */
    public function setTestExtensibility($testExtensibility = false)
    {
        $this->testExtensibility = $testExtensibility;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\ProceedRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
