<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pointOfSalePaymentReceiptValues StructType
 * Meta informations extracted from the WSDL
 * - documentation: Point Of Sale payment receipt values.
 * @subpackage Structs
 */
class PointOfSalePaymentReceiptValues extends AbstractStructBase
{
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Value[]
     */
    public $value;
    /**
     * Constructor method for pointOfSalePaymentReceiptValues
     * @uses PointOfSalePaymentReceiptValues::setValue()
     * @param \Models\Docdata\StructType\Value[] $value
     */
    public function __construct(array $value = array())
    {
        $this
            ->setValue($value);
    }
    /**
     * Get value value
     * @return \Models\Docdata\StructType\Value[]
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @throws \InvalidArgumentException
     * @param \Models\Docdata\StructType\Value[] $value
     * @return \Models\Docdata\StructType\PointOfSalePaymentReceiptValues
     */
    public function setValue(array $value = array())
    {
        foreach ($value as $pointOfSalePaymentReceiptValuesValueItem) {
            // validation for constraint: itemType
            if (!$pointOfSalePaymentReceiptValuesValueItem instanceof \Models\Docdata\StructType\Value) {
                throw new \InvalidArgumentException(sprintf('The value property can only contain items of \Models\Docdata\StructType\Value, "%s" given', is_object($pointOfSalePaymentReceiptValuesValueItem) ? get_class($pointOfSalePaymentReceiptValuesValueItem) : gettype($pointOfSalePaymentReceiptValuesValueItem)), __LINE__);
            }
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Add item to value value
     * @throws \InvalidArgumentException
     * @param \Models\Docdata\StructType\Value $item
     * @return \Models\Docdata\StructType\PointOfSalePaymentReceiptValues
     */
    public function addToValue(\Models\Docdata\StructType\Value $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Models\Docdata\StructType\Value) {
            throw new \InvalidArgumentException(sprintf('The value property can only contain items of \Models\Docdata\StructType\Value, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->value[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\PointOfSalePaymentReceiptValues
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
