<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentRequestInput StructType
 * Meta informations extracted from the WSDL
 * - documentation: Payment information to start a payment.
 * @subpackage Structs
 */
class PaymentRequestInput extends AbstractStructBase
{
    /**
     * The paymentMethod
     * Meta informations extracted from the WSDL
     * - documentation: Payment method to be used.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $paymentMethod;
    /**
     * The amexPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\CardPaymentInput
     */
    public $amexPaymentInput;
    /**
     * The masterCardPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\CardPaymentInput
     */
    public $masterCardPaymentInput;
    /**
     * The misterCashPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\CardPaymentInput
     */
    public $misterCashPaymentInput;
    /**
     * The maestroPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\CardPaymentInput
     */
    public $maestroPaymentInput;
    /**
     * The visaPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\CardPaymentInput
     */
    public $visaPaymentInput;
    /**
     * The directDebitPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\DirectDebitPaymentInput
     */
    public $directDebitPaymentInput;
    /**
     * The bankTransferPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\BankTransferPaymentInput
     */
    public $bankTransferPaymentInput;
    /**
     * The pointOfSalePaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\PointOfSalePaymentInput
     */
    public $pointOfSalePaymentInput;
    /**
     * The offlinePaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\OfflinePaymentInput
     */
    public $offlinePaymentInput;
    /**
     * The elvPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\ElvPaymentInput
     */
    public $elvPaymentInput;
    /**
     * The iDealPaymentInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\IDealPaymentInput
     */
    public $iDealPaymentInput;
    /**
     * Constructor method for paymentRequestInput
     * @uses PaymentRequestInput::setPaymentMethod()
     * @uses PaymentRequestInput::setAmexPaymentInput()
     * @uses PaymentRequestInput::setMasterCardPaymentInput()
     * @uses PaymentRequestInput::setMisterCashPaymentInput()
     * @uses PaymentRequestInput::setMaestroPaymentInput()
     * @uses PaymentRequestInput::setVisaPaymentInput()
     * @uses PaymentRequestInput::setDirectDebitPaymentInput()
     * @uses PaymentRequestInput::setBankTransferPaymentInput()
     * @uses PaymentRequestInput::setPointOfSalePaymentInput()
     * @uses PaymentRequestInput::setOfflinePaymentInput()
     * @uses PaymentRequestInput::setElvPaymentInput()
     * @uses PaymentRequestInput::setIDealPaymentInput()
     * @param string $paymentMethod
     * @param \Models\Docdata\StructType\CardPaymentInput $amexPaymentInput
     * @param \Models\Docdata\StructType\CardPaymentInput $masterCardPaymentInput
     * @param \Models\Docdata\StructType\CardPaymentInput $misterCashPaymentInput
     * @param \Models\Docdata\StructType\CardPaymentInput $maestroPaymentInput
     * @param \Models\Docdata\StructType\CardPaymentInput $visaPaymentInput
     * @param \Models\Docdata\StructType\DirectDebitPaymentInput $directDebitPaymentInput
     * @param \Models\Docdata\StructType\BankTransferPaymentInput $bankTransferPaymentInput
     * @param \Models\Docdata\StructType\PointOfSalePaymentInput $pointOfSalePaymentInput
     * @param \Models\Docdata\StructType\OfflinePaymentInput $offlinePaymentInput
     * @param \Models\Docdata\StructType\ElvPaymentInput $elvPaymentInput
     * @param \Models\Docdata\StructType\IDealPaymentInput $iDealPaymentInput
     */
    public function __construct($paymentMethod = null, \Models\Docdata\StructType\CardPaymentInput $amexPaymentInput = null, \Models\Docdata\StructType\CardPaymentInput $masterCardPaymentInput = null, \Models\Docdata\StructType\CardPaymentInput $misterCashPaymentInput = null, \Models\Docdata\StructType\CardPaymentInput $maestroPaymentInput = null, \Models\Docdata\StructType\CardPaymentInput $visaPaymentInput = null, \Models\Docdata\StructType\DirectDebitPaymentInput $directDebitPaymentInput = null, \Models\Docdata\StructType\BankTransferPaymentInput $bankTransferPaymentInput = null, \Models\Docdata\StructType\PointOfSalePaymentInput $pointOfSalePaymentInput = null, \Models\Docdata\StructType\OfflinePaymentInput $offlinePaymentInput = null, \Models\Docdata\StructType\ElvPaymentInput $elvPaymentInput = null, \Models\Docdata\StructType\IDealPaymentInput $iDealPaymentInput = null)
    {
        $this
            ->setPaymentMethod($paymentMethod)
            ->setAmexPaymentInput($amexPaymentInput)
            ->setMasterCardPaymentInput($masterCardPaymentInput)
            ->setMisterCashPaymentInput($misterCashPaymentInput)
            ->setMaestroPaymentInput($maestroPaymentInput)
            ->setVisaPaymentInput($visaPaymentInput)
            ->setDirectDebitPaymentInput($directDebitPaymentInput)
            ->setBankTransferPaymentInput($bankTransferPaymentInput)
            ->setPointOfSalePaymentInput($pointOfSalePaymentInput)
            ->setOfflinePaymentInput($offlinePaymentInput)
            ->setElvPaymentInput($elvPaymentInput)
            ->setIDealPaymentInput($iDealPaymentInput);
    }
    /**
     * Get paymentMethod value
     * @return string
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param string $paymentMethod
     * @return \Models\Docdata\StructType\PaymentRequestInput
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($paymentMethod) && strlen($paymentMethod) > 50) || (is_array($paymentMethod) && count($paymentMethod) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($paymentMethod) ? strlen($paymentMethod) : count($paymentMethod)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($paymentMethod) && strlen($paymentMethod) < 1) || (is_array($paymentMethod) && count($paymentMethod) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentMethod)), __LINE__);
        }
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get amexPaymentInput value
     * @return \Models\Docdata\StructType\CardPaymentInput
     */
    public function getAmexPaymentInput()
    {
        return $this->amexPaymentInput;
    }
    /**
     * Set amexPaymentInput value
     * @param \Models\Docdata\StructType\CardPaymentInput $amexPaymentInput
     * @return \Models\Docdata\StructType\PaymentRequestInput
     */
    public function setAmexPaymentInput(\Models\Docdata\StructType\CardPaymentInput $amexPaymentInput = null)
    {
        $this->amexPaymentInput = $amexPaymentInput;
        return $this;
    }
    /**
     * Get masterCardPaymentInput value
     * @return \Models\Docdata\StructType\CardPaymentInput
     */
    public function getMasterCardPaymentInput()
    {
        return $this->masterCardPaymentInput;
    }
    /**
     * Set masterCardPaymentInput value
     * @param \Models\Docdata\StructType\CardPaymentInput $masterCardPaymentInput
     * @return \Models\Docdata\StructType\PaymentRequestInput
     */
    public function setMasterCardPaymentInput(\Models\Docdata\StructType\CardPaymentInput $masterCardPaymentInput = null)
    {
        $this->masterCardPaymentInput = $masterCardPaymentInput;
        return $this;
    }
    /**
     * Get misterCashPaymentInput value
     * @return \Models\Docdata\StructType\CardPaymentInput
     */
    public function getMisterCashPaymentInput()
    {
        return $this->misterCashPaymentInput;
    }
    /**
     * Set misterCashPaymentInput value
     * @param \Models\Docdata\StructType\CardPaymentInput $misterCashPaymentInput
     * @return \Models\Docdata\StructType\PaymentRequestInput
     */
    public function setMisterCashPaymentInput(\Models\Docdata\StructType\CardPaymentInput $misterCashPaymentInput = null)
    {
        $this->misterCashPaymentInput = $misterCashPaymentInput;
        return $this;
    }
    /**
     * Get maestroPaymentInput value
     * @return \Models\Docdata\StructType\CardPaymentInput
     */
    public function getMaestroPaymentInput()
    {
        return $this->maestroPaymentInput;
    }
    /**
     * Set maestroPaymentInput value
     * @param \Models\Docdata\StructType\CardPaymentInput $maestroPaymentInput
     * @return \Models\Docdata\StructType\PaymentRequestInput
     */
    public function setMaestroPaymentInput(\Models\Docdata\StructType\CardPaymentInput $maestroPaymentInput = null)
    {
        $this->maestroPaymentInput = $maestroPaymentInput;
        return $this;
    }
    /**
     * Get visaPaymentInput value
     * @return \Models\Docdata\StructType\CardPaymentInput
     */
    public function getVisaPaymentInput()
    {
        return $this->visaPaymentInput;
    }
    /**
     * Set visaPaymentInput value
     * @param \Models\Docdata\StructType\CardPaymentInput $visaPaymentInput
     * @return \Models\Docdata\StructType\PaymentRequestInput
     */
    public function setVisaPaymentInput(\Models\Docdata\StructType\CardPaymentInput $visaPaymentInput = null)
    {
        $this->visaPaymentInput = $visaPaymentInput;
        return $this;
    }
    /**
     * Get directDebitPaymentInput value
     * @return \Models\Docdata\StructType\DirectDebitPaymentInput
     */
    public function getDirectDebitPaymentInput()
    {
        return $this->directDebitPaymentInput;
    }
    /**
     * Set directDebitPaymentInput value
     * @param \Models\Docdata\StructType\DirectDebitPaymentInput $directDebitPaymentInput
     * @return \Models\Docdata\StructType\PaymentRequestInput
     */
    public function setDirectDebitPaymentInput(\Models\Docdata\StructType\DirectDebitPaymentInput $directDebitPaymentInput = null)
    {
        $this->directDebitPaymentInput = $directDebitPaymentInput;
        return $this;
    }
    /**
     * Get bankTransferPaymentInput value
     * @return \Models\Docdata\StructType\BankTransferPaymentInput
     */
    public function getBankTransferPaymentInput()
    {
        return $this->bankTransferPaymentInput;
    }
    /**
     * Set bankTransferPaymentInput value
     * @param \Models\Docdata\StructType\BankTransferPaymentInput $bankTransferPaymentInput
     * @return \Models\Docdata\StructType\PaymentRequestInput
     */
    public function setBankTransferPaymentInput(\Models\Docdata\StructType\BankTransferPaymentInput $bankTransferPaymentInput = null)
    {
        $this->bankTransferPaymentInput = $bankTransferPaymentInput;
        return $this;
    }
    /**
     * Get pointOfSalePaymentInput value
     * @return \Models\Docdata\StructType\PointOfSalePaymentInput
     */
    public function getPointOfSalePaymentInput()
    {
        return $this->pointOfSalePaymentInput;
    }
    /**
     * Set pointOfSalePaymentInput value
     * @param \Models\Docdata\StructType\PointOfSalePaymentInput $pointOfSalePaymentInput
     * @return \Models\Docdata\StructType\PaymentRequestInput
     */
    public function setPointOfSalePaymentInput(\Models\Docdata\StructType\PointOfSalePaymentInput $pointOfSalePaymentInput = null)
    {
        $this->pointOfSalePaymentInput = $pointOfSalePaymentInput;
        return $this;
    }
    /**
     * Get offlinePaymentInput value
     * @return \Models\Docdata\StructType\OfflinePaymentInput
     */
    public function getOfflinePaymentInput()
    {
        return $this->offlinePaymentInput;
    }
    /**
     * Set offlinePaymentInput value
     * @param \Models\Docdata\StructType\OfflinePaymentInput $offlinePaymentInput
     * @return \Models\Docdata\StructType\PaymentRequestInput
     */
    public function setOfflinePaymentInput(\Models\Docdata\StructType\OfflinePaymentInput $offlinePaymentInput = null)
    {
        $this->offlinePaymentInput = $offlinePaymentInput;
        return $this;
    }
    /**
     * Get elvPaymentInput value
     * @return \Models\Docdata\StructType\ElvPaymentInput
     */
    public function getElvPaymentInput()
    {
        return $this->elvPaymentInput;
    }
    /**
     * Set elvPaymentInput value
     * @param \Models\Docdata\StructType\ElvPaymentInput $elvPaymentInput
     * @return \Models\Docdata\StructType\PaymentRequestInput
     */
    public function setElvPaymentInput(\Models\Docdata\StructType\ElvPaymentInput $elvPaymentInput = null)
    {
        $this->elvPaymentInput = $elvPaymentInput;
        return $this;
    }
    /**
     * Get iDealPaymentInput value
     * @return \Models\Docdata\StructType\IDealPaymentInput
     */
    public function getIDealPaymentInput()
    {
        return $this->iDealPaymentInput;
    }
    /**
     * Set iDealPaymentInput value
     * @param \Models\Docdata\StructType\IDealPaymentInput $iDealPaymentInput
     * @return \Models\Docdata\StructType\PaymentRequestInput
     */
    public function setIDealPaymentInput(\Models\Docdata\StructType\IDealPaymentInput $iDealPaymentInput = null)
    {
        $this->iDealPaymentInput = $iDealPaymentInput;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\PaymentRequestInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
