<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentPreferences StructType
 * @subpackage Structs
 */
class PaymentPreferences extends AbstractStructBase
{
    /**
     * The profile
     * Meta informations extracted from the WSDL
     * - documentation: The profile that is used to select the payment methods that can be used to pay this order.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $profile;
    /**
     * The numberOfDaysToPay
     * Meta informations extracted from the WSDL
     * - documentation: The expected number of days in which the payment should be processed, or be expired if not paid.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfDaysToPay;
    /**
     * The exhortation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\Exhortation
     */
    public $exhortation;
    /**
     * The terminalId
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the Point Of Sale terminal.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $terminalId;
    /**
     * Constructor method for paymentPreferences
     * @uses PaymentPreferences::setProfile()
     * @uses PaymentPreferences::setNumberOfDaysToPay()
     * @uses PaymentPreferences::setExhortation()
     * @uses PaymentPreferences::setTerminalId()
     * @param string $profile
     * @param int $numberOfDaysToPay
     * @param \Models\Docdata\StructType\Exhortation $exhortation
     * @param string $terminalId
     */
    public function __construct($profile = null, $numberOfDaysToPay = null, \Models\Docdata\StructType\Exhortation $exhortation = null, $terminalId = null)
    {
        $this
            ->setProfile($profile)
            ->setNumberOfDaysToPay($numberOfDaysToPay)
            ->setExhortation($exhortation)
            ->setTerminalId($terminalId);
    }
    /**
     * Get profile value
     * @return string
     */
    public function getProfile()
    {
        return $this->profile;
    }
    /**
     * Set profile value
     * @param string $profile
     * @return \Models\Docdata\StructType\PaymentPreferences
     */
    public function setProfile($profile = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($profile) && strlen($profile) > 50) || (is_array($profile) && count($profile) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($profile) ? strlen($profile) : count($profile)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($profile) && strlen($profile) < 1) || (is_array($profile) && count($profile) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($profile) && !is_string($profile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profile)), __LINE__);
        }
        $this->profile = $profile;
        return $this;
    }
    /**
     * Get numberOfDaysToPay value
     * @return int
     */
    public function getNumberOfDaysToPay()
    {
        return $this->numberOfDaysToPay;
    }
    /**
     * Set numberOfDaysToPay value
     * @param int $numberOfDaysToPay
     * @return \Models\Docdata\StructType\PaymentPreferences
     */
    public function setNumberOfDaysToPay($numberOfDaysToPay = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDaysToPay) && !is_numeric($numberOfDaysToPay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfDaysToPay)), __LINE__);
        }
        $this->numberOfDaysToPay = $numberOfDaysToPay;
        return $this;
    }
    /**
     * Get exhortation value
     * @return \Models\Docdata\StructType\Exhortation|null
     */
    public function getExhortation()
    {
        return $this->exhortation;
    }
    /**
     * Set exhortation value
     * @param \Models\Docdata\StructType\Exhortation $exhortation
     * @return \Models\Docdata\StructType\PaymentPreferences
     */
    public function setExhortation(\Models\Docdata\StructType\Exhortation $exhortation = null)
    {
        $this->exhortation = $exhortation;
        return $this;
    }
    /**
     * Get terminalId value
     * @return string|null
     */
    public function getTerminalId()
    {
        return $this->terminalId;
    }
    /**
     * Set terminalId value
     * @param string $terminalId
     * @return \Models\Docdata\StructType\PaymentPreferences
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($terminalId) && strlen($terminalId) > 35) || (is_array($terminalId) && count($terminalId) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($terminalId) ? strlen($terminalId) : count($terminalId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($terminalId) && strlen($terminalId) < 1) || (is_array($terminalId) && count($terminalId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($terminalId) && !is_string($terminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminalId)), __LINE__);
        }
        $this->terminalId = $terminalId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\PaymentPreferences
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
