<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parameters StructType
 * @subpackage Structs
 */
class Parameters extends AbstractStructBase
{
    /**
     * The parameter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\Parameter[]
     */
    public $parameter;
    /**
     * Constructor method for parameters
     * @uses Parameters::setParameter()
     * @param \Models\Docdata\StructType\Parameter[] $parameter
     */
    public function __construct(array $parameter = array())
    {
        $this
            ->setParameter($parameter);
    }
    /**
     * Get parameter value
     * @return \Models\Docdata\StructType\Parameter[]|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * Set parameter value
     * @throws \InvalidArgumentException
     * @param \Models\Docdata\StructType\Parameter[] $parameter
     * @return \Models\Docdata\StructType\Parameters
     */
    public function setParameter(array $parameter = array())
    {
        foreach ($parameter as $parametersParameterItem) {
            // validation for constraint: itemType
            if (!$parametersParameterItem instanceof \Models\Docdata\StructType\Parameter) {
                throw new \InvalidArgumentException(sprintf('The parameter property can only contain items of \Models\Docdata\StructType\Parameter, "%s" given', is_object($parametersParameterItem) ? get_class($parametersParameterItem) : gettype($parametersParameterItem)), __LINE__);
            }
        }
        $this->parameter = $parameter;
        return $this;
    }
    /**
     * Add item to parameter value
     * @throws \InvalidArgumentException
     * @param \Models\Docdata\StructType\Parameter $item
     * @return \Models\Docdata\StructType\Parameters
     */
    public function addToParameter(\Models\Docdata\StructType\Parameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Models\Docdata\StructType\Parameter) {
            throw new \InvalidArgumentException(sprintf('The parameter property can only contain items of \Models\Docdata\StructType\Parameter, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->parameter[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\Parameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
