<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for name StructType
 * @subpackage Structs
 */
class Name extends AbstractStructBase
{
    /**
     * The first
     * Meta informations extracted from the WSDL
     * - documentation: The first given name.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $first;
    /**
     * The last
     * Meta informations extracted from the WSDL
     * - documentation: The family or inherited name(s).
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $last;
    /**
     * The prefix
     * Meta informations extracted from the WSDL
     * - documentation: For example: Mr., Mrs., Ms., Dr. This field is commonly omitted.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $prefix;
    /**
     * The initials
     * Meta informations extracted from the WSDL
     * - documentation: The initials.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $initials;
    /**
     * The middle
     * Meta informations extracted from the WSDL
     * - documentation: Any subsequent given name or names. May also be used as middle initial.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $middle;
    /**
     * The suffix
     * Meta informations extracted from the WSDL
     * - documentation: For example: Ph.D., Jr. (Junior), 3rd, Esq. (Exquire). This field is commonly omitted.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $suffix;
    /**
     * Constructor method for name
     * @uses Name::setFirst()
     * @uses Name::setLast()
     * @uses Name::setPrefix()
     * @uses Name::setInitials()
     * @uses Name::setMiddle()
     * @uses Name::setSuffix()
     * @param string $first
     * @param string $last
     * @param string $prefix
     * @param string $initials
     * @param string $middle
     * @param string $suffix
     */
    public function __construct($first = null, $last = null, $prefix = null, $initials = null, $middle = null, $suffix = null)
    {
        $this
            ->setFirst($first)
            ->setLast($last)
            ->setPrefix($prefix)
            ->setInitials($initials)
            ->setMiddle($middle)
            ->setSuffix($suffix);
    }
    /**
     * Get first value
     * @return string
     */
    public function getFirst()
    {
        return $this->first;
    }
    /**
     * Set first value
     * @param string $first
     * @return \Models\Docdata\StructType\Name
     */
    public function setFirst($first = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($first) && strlen($first) > 35) || (is_array($first) && count($first) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($first) ? strlen($first) : count($first)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($first) && strlen($first) < 1) || (is_array($first) && count($first) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($first) && !is_string($first)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($first)), __LINE__);
        }
        $this->first = $first;
        return $this;
    }
    /**
     * Get last value
     * @return string
     */
    public function getLast()
    {
        return $this->last;
    }
    /**
     * Set last value
     * @param string $last
     * @return \Models\Docdata\StructType\Name
     */
    public function setLast($last = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($last) && strlen($last) > 35) || (is_array($last) && count($last) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($last) ? strlen($last) : count($last)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($last) && strlen($last) < 1) || (is_array($last) && count($last) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($last) && !is_string($last)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last)), __LINE__);
        }
        $this->last = $last;
        return $this;
    }
    /**
     * Get prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \Models\Docdata\StructType\Name
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prefix) && strlen($prefix) > 50) || (is_array($prefix) && count($prefix) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($prefix) ? strlen($prefix) : count($prefix)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($prefix) && strlen($prefix) < 1) || (is_array($prefix) && count($prefix) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefix)), __LINE__);
        }
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get initials value
     * @return string|null
     */
    public function getInitials()
    {
        return $this->initials;
    }
    /**
     * Set initials value
     * @param string $initials
     * @return \Models\Docdata\StructType\Name
     */
    public function setInitials($initials = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($initials) && strlen($initials) > 35) || (is_array($initials) && count($initials) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($initials) ? strlen($initials) : count($initials)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($initials) && strlen($initials) < 1) || (is_array($initials) && count($initials) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($initials) && !is_string($initials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($initials)), __LINE__);
        }
        $this->initials = $initials;
        return $this;
    }
    /**
     * Get middle value
     * @return string|null
     */
    public function getMiddle()
    {
        return $this->middle;
    }
    /**
     * Set middle value
     * @param string $middle
     * @return \Models\Docdata\StructType\Name
     */
    public function setMiddle($middle = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($middle) && strlen($middle) > 35) || (is_array($middle) && count($middle) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($middle) ? strlen($middle) : count($middle)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($middle) && strlen($middle) < 1) || (is_array($middle) && count($middle) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($middle) && !is_string($middle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middle)), __LINE__);
        }
        $this->middle = $middle;
        return $this;
    }
    /**
     * Get suffix value
     * @return string|null
     */
    public function getSuffix()
    {
        return $this->suffix;
    }
    /**
     * Set suffix value
     * @param string $suffix
     * @return \Models\Docdata\StructType\Name
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($suffix) && strlen($suffix) > 50) || (is_array($suffix) && count($suffix) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($suffix) ? strlen($suffix) : count($suffix)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($suffix) && strlen($suffix) < 1) || (is_array($suffix) && count($suffix) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suffix)), __LINE__);
        }
        $this->suffix = $suffix;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\Name
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
