<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for exhortationPeriod StructType
 * @subpackage Structs
 */
class ExhortationPeriod extends AbstractStructBase
{
    /**
     * The numberOfDays
     * Meta informations extracted from the WSDL
     * - documentation: The number of days after communication to the shopper the exhortation period will be initiated.
     * - use: required
     * @var int
     */
    public $numberOfDays;
    /**
     * The profile
     * Meta informations extracted from the WSDL
     * - documentation: The profile that is used to determine the payment methods for this order during this exhortation period.
     * - use: optional
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $profile;
    /**
     * Constructor method for exhortationPeriod
     * @uses ExhortationPeriod::setNumberOfDays()
     * @uses ExhortationPeriod::setProfile()
     * @param int $numberOfDays
     * @param string $profile
     */
    public function __construct($numberOfDays = null, $profile = null)
    {
        $this
            ->setNumberOfDays($numberOfDays)
            ->setProfile($profile);
    }
    /**
     * Get numberOfDays value
     * @return int
     */
    public function getNumberOfDays()
    {
        return $this->numberOfDays;
    }
    /**
     * Set numberOfDays value
     * @param int $numberOfDays
     * @return \Models\Docdata\StructType\ExhortationPeriod
     */
    public function setNumberOfDays($numberOfDays = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDays) && !is_numeric($numberOfDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfDays)), __LINE__);
        }
        $this->numberOfDays = $numberOfDays;
        return $this;
    }
    /**
     * Get profile value
     * @return string|null
     */
    public function getProfile()
    {
        return $this->profile;
    }
    /**
     * Set profile value
     * @param string $profile
     * @return \Models\Docdata\StructType\ExhortationPeriod
     */
    public function setProfile($profile = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($profile) && strlen($profile) > 50) || (is_array($profile) && count($profile) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($profile) ? strlen($profile) : count($profile)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($profile) && strlen($profile) < 1) || (is_array($profile) && count($profile) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($profile) && !is_string($profile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profile)), __LINE__);
        }
        $this->profile = $profile;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\ExhortationPeriod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
