<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response to a cancel request.
 * @subpackage Structs
 */
class CancelResponse extends AbstractStructBase
{
    /**
     * The cancelErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\CancelErrors
     */
    public $cancelErrors;
    /**
     * The cancelSuccess
     * Meta informations extracted from the WSDL
     * - documentation: Returns summarized information about cancelation of the payments of this order. Use "status" to retrieve more information.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\CancelSuccess
     */
    public $cancelSuccess;
    /**
     * The ddpXsdVersion
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $ddpXsdVersion;
    /**
     * Constructor method for cancelResponse
     * @uses CancelResponse::setCancelErrors()
     * @uses CancelResponse::setCancelSuccess()
     * @uses CancelResponse::setDdpXsdVersion()
     * @param \Models\Docdata\StructType\CancelErrors $cancelErrors
     * @param \Models\Docdata\StructType\CancelSuccess $cancelSuccess
     * @param string $ddpXsdVersion
     */
    public function __construct(\Models\Docdata\StructType\CancelErrors $cancelErrors = null, \Models\Docdata\StructType\CancelSuccess $cancelSuccess = null, $ddpXsdVersion = null)
    {
        $this
            ->setCancelErrors($cancelErrors)
            ->setCancelSuccess($cancelSuccess)
            ->setDdpXsdVersion($ddpXsdVersion);
    }
    /**
     * Get cancelErrors value
     * @return \Models\Docdata\StructType\CancelErrors
     */
    public function getCancelErrors()
    {
        return $this->cancelErrors;
    }
    /**
     * Set cancelErrors value
     * @param \Models\Docdata\StructType\CancelErrors $cancelErrors
     * @return \Models\Docdata\StructType\CancelResponse
     */
    public function setCancelErrors(\Models\Docdata\StructType\CancelErrors $cancelErrors = null)
    {
        $this->cancelErrors = $cancelErrors;
        return $this;
    }
    /**
     * Get cancelSuccess value
     * @return \Models\Docdata\StructType\CancelSuccess
     */
    public function getCancelSuccess()
    {
        return $this->cancelSuccess;
    }
    /**
     * Set cancelSuccess value
     * @param \Models\Docdata\StructType\CancelSuccess $cancelSuccess
     * @return \Models\Docdata\StructType\CancelResponse
     */
    public function setCancelSuccess(\Models\Docdata\StructType\CancelSuccess $cancelSuccess = null)
    {
        $this->cancelSuccess = $cancelSuccess;
        return $this;
    }
    /**
     * Get ddpXsdVersion value
     * @return string
     */
    public function getDdpXsdVersion()
    {
        return $this->ddpXsdVersion;
    }
    /**
     * Set ddpXsdVersion value
     * @param string $ddpXsdVersion
     * @return \Models\Docdata\StructType\CancelResponse
     */
    public function setDdpXsdVersion($ddpXsdVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) > 35) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($ddpXsdVersion) ? strlen($ddpXsdVersion) : count($ddpXsdVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) < 1) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ddpXsdVersion) && !is_string($ddpXsdVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ddpXsdVersion)), __LINE__);
        }
        $this->ddpXsdVersion = $ddpXsdVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\CancelResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
