<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bankTransferPaymentInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Payment information concerning the bank payment methods.
 * @subpackage Structs
 */
class BankTransferPaymentInfo extends AbstractStructBase
{
    /**
     * The bic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1 | 1
     * - minOccurs: 0 | 0
     * - maxLength: 11
     * - minLength: 8
     * - type: ddp:bic
     * @var string
     */
    public $bic;
    /**
     * The iban
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1 | 1
     * - minOccurs: 0 | 1
     * - maxLength: 34
     * - minLength: 15
     * - type: ddp:iban
     * @var string
     */
    public $iban;
    /**
     * The beneficiaryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $beneficiaryName;
    /**
     * The beneficiaryCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $beneficiaryCity;
    /**
     * The beneficiaryCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $beneficiaryCountry;
    /**
     * The bankName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $bankName;
    /**
     * The bankCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $bankCity;
    /**
     * The bankCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $bankCode;
    /**
     * The bankAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $bankAccountNumber;
    /**
     * The shopperBankAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\ShopperBankAccount
     */
    public $shopperBankAccount;
    /**
     * Constructor method for bankTransferPaymentInfo
     * @uses BankTransferPaymentInfo::setBic()
     * @uses BankTransferPaymentInfo::setIban()
     * @uses BankTransferPaymentInfo::setBeneficiaryName()
     * @uses BankTransferPaymentInfo::setBeneficiaryCity()
     * @uses BankTransferPaymentInfo::setBeneficiaryCountry()
     * @uses BankTransferPaymentInfo::setBankName()
     * @uses BankTransferPaymentInfo::setBankCity()
     * @uses BankTransferPaymentInfo::setBankCode()
     * @uses BankTransferPaymentInfo::setBankAccountNumber()
     * @uses BankTransferPaymentInfo::setShopperBankAccount()
     * @param string $bic
     * @param string $iban
     * @param string $beneficiaryName
     * @param string $beneficiaryCity
     * @param string $beneficiaryCountry
     * @param string $bankName
     * @param string $bankCity
     * @param string $bankCode
     * @param string $bankAccountNumber
     * @param \Models\Docdata\StructType\ShopperBankAccount $shopperBankAccount
     */
    public function __construct($bic = null, $iban = null, $beneficiaryName = null, $beneficiaryCity = null, $beneficiaryCountry = null, $bankName = null, $bankCity = null, $bankCode = null, $bankAccountNumber = null, \Models\Docdata\StructType\ShopperBankAccount $shopperBankAccount = null)
    {
        $this
            ->setBic($bic)
            ->setIban($iban)
            ->setBeneficiaryName($beneficiaryName)
            ->setBeneficiaryCity($beneficiaryCity)
            ->setBeneficiaryCountry($beneficiaryCountry)
            ->setBankName($bankName)
            ->setBankCity($bankCity)
            ->setBankCode($bankCode)
            ->setBankAccountNumber($bankAccountNumber)
            ->setShopperBankAccount($shopperBankAccount);
    }
    /**
     * Get bic value
     * @return string
     */
    public function getBic()
    {
        return $this->bic;
    }
    /**
     * Set bic value
     * @param string $bic
     * @return \Models\Docdata\StructType\BankTransferPaymentInfo
     */
    public function setBic($bic = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bic) && strlen($bic) > 11) || (is_array($bic) && count($bic) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($bic) ? strlen($bic) : count($bic)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bic) && strlen($bic) < 8) || (is_array($bic) && count($bic) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bic) && !is_string($bic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bic)), __LINE__);
        }
        $this->bic = $bic;
        return $this;
    }
    /**
     * Get iban value
     * @return string
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \Models\Docdata\StructType\BankTransferPaymentInfo
     */
    public function setIban($iban = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iban) && strlen($iban) > 34) || (is_array($iban) && count($iban) > 34)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 34 element(s) or a scalar of 34 character(s) at most, "%d" length given', is_scalar($iban) ? strlen($iban) : count($iban)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iban) && strlen($iban) < 15) || (is_array($iban) && count($iban) < 15)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
    /**
     * Get beneficiaryName value
     * @return string|null
     */
    public function getBeneficiaryName()
    {
        return $this->beneficiaryName;
    }
    /**
     * Set beneficiaryName value
     * @param string $beneficiaryName
     * @return \Models\Docdata\StructType\BankTransferPaymentInfo
     */
    public function setBeneficiaryName($beneficiaryName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($beneficiaryName) && strlen($beneficiaryName) > 50) || (is_array($beneficiaryName) && count($beneficiaryName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($beneficiaryName) ? strlen($beneficiaryName) : count($beneficiaryName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($beneficiaryName) && strlen($beneficiaryName) < 1) || (is_array($beneficiaryName) && count($beneficiaryName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($beneficiaryName) && !is_string($beneficiaryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beneficiaryName)), __LINE__);
        }
        $this->beneficiaryName = $beneficiaryName;
        return $this;
    }
    /**
     * Get beneficiaryCity value
     * @return string|null
     */
    public function getBeneficiaryCity()
    {
        return $this->beneficiaryCity;
    }
    /**
     * Set beneficiaryCity value
     * @param string $beneficiaryCity
     * @return \Models\Docdata\StructType\BankTransferPaymentInfo
     */
    public function setBeneficiaryCity($beneficiaryCity = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($beneficiaryCity) && strlen($beneficiaryCity) > 50) || (is_array($beneficiaryCity) && count($beneficiaryCity) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($beneficiaryCity) ? strlen($beneficiaryCity) : count($beneficiaryCity)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($beneficiaryCity) && strlen($beneficiaryCity) < 1) || (is_array($beneficiaryCity) && count($beneficiaryCity) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($beneficiaryCity) && !is_string($beneficiaryCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beneficiaryCity)), __LINE__);
        }
        $this->beneficiaryCity = $beneficiaryCity;
        return $this;
    }
    /**
     * Get beneficiaryCountry value
     * @return string|null
     */
    public function getBeneficiaryCountry()
    {
        return $this->beneficiaryCountry;
    }
    /**
     * Set beneficiaryCountry value
     * @param string $beneficiaryCountry
     * @return \Models\Docdata\StructType\BankTransferPaymentInfo
     */
    public function setBeneficiaryCountry($beneficiaryCountry = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($beneficiaryCountry) && strlen($beneficiaryCountry) > 50) || (is_array($beneficiaryCountry) && count($beneficiaryCountry) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($beneficiaryCountry) ? strlen($beneficiaryCountry) : count($beneficiaryCountry)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($beneficiaryCountry) && strlen($beneficiaryCountry) < 1) || (is_array($beneficiaryCountry) && count($beneficiaryCountry) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($beneficiaryCountry) && !is_string($beneficiaryCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beneficiaryCountry)), __LINE__);
        }
        $this->beneficiaryCountry = $beneficiaryCountry;
        return $this;
    }
    /**
     * Get bankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->bankName;
    }
    /**
     * Set bankName value
     * @param string $bankName
     * @return \Models\Docdata\StructType\BankTransferPaymentInfo
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankName) && strlen($bankName) > 50) || (is_array($bankName) && count($bankName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($bankName) ? strlen($bankName) : count($bankName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bankName) && strlen($bankName) < 1) || (is_array($bankName) && count($bankName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->bankName = $bankName;
        return $this;
    }
    /**
     * Get bankCity value
     * @return string|null
     */
    public function getBankCity()
    {
        return $this->bankCity;
    }
    /**
     * Set bankCity value
     * @param string $bankCity
     * @return \Models\Docdata\StructType\BankTransferPaymentInfo
     */
    public function setBankCity($bankCity = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankCity) && strlen($bankCity) > 35) || (is_array($bankCity) && count($bankCity) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($bankCity) ? strlen($bankCity) : count($bankCity)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bankCity) && strlen($bankCity) < 1) || (is_array($bankCity) && count($bankCity) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankCity) && !is_string($bankCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankCity)), __LINE__);
        }
        $this->bankCity = $bankCity;
        return $this;
    }
    /**
     * Get bankCode value
     * @return string|null
     */
    public function getBankCode()
    {
        return $this->bankCode;
    }
    /**
     * Set bankCode value
     * @param string $bankCode
     * @return \Models\Docdata\StructType\BankTransferPaymentInfo
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankCode) && strlen($bankCode) > 35) || (is_array($bankCode) && count($bankCode) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($bankCode) ? strlen($bankCode) : count($bankCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bankCode) && strlen($bankCode) < 1) || (is_array($bankCode) && count($bankCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankCode)), __LINE__);
        }
        $this->bankCode = $bankCode;
        return $this;
    }
    /**
     * Get bankAccountNumber value
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->bankAccountNumber;
    }
    /**
     * Set bankAccountNumber value
     * @param string $bankAccountNumber
     * @return \Models\Docdata\StructType\BankTransferPaymentInfo
     */
    public function setBankAccountNumber($bankAccountNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankAccountNumber) && strlen($bankAccountNumber) > 50) || (is_array($bankAccountNumber) && count($bankAccountNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($bankAccountNumber) ? strlen($bankAccountNumber) : count($bankAccountNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bankAccountNumber) && strlen($bankAccountNumber) < 1) || (is_array($bankAccountNumber) && count($bankAccountNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankAccountNumber) && !is_string($bankAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountNumber)), __LINE__);
        }
        $this->bankAccountNumber = $bankAccountNumber;
        return $this;
    }
    /**
     * Get shopperBankAccount value
     * @return \Models\Docdata\StructType\ShopperBankAccount|null
     */
    public function getShopperBankAccount()
    {
        return $this->shopperBankAccount;
    }
    /**
     * Set shopperBankAccount value
     * @param \Models\Docdata\StructType\ShopperBankAccount $shopperBankAccount
     * @return \Models\Docdata\StructType\BankTransferPaymentInfo
     */
    public function setShopperBankAccount(\Models\Docdata\StructType\ShopperBankAccount $shopperBankAccount = null)
    {
        $this->shopperBankAccount = $shopperBankAccount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\BankTransferPaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
