<?php

namespace Models\Docdata\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Status ServiceType
 * @subpackage Services
 */
class Status extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named status
     * Meta informations extracted from the WSDL
     * - documentation: Retrieves a report that describes the state of a specified payment order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Models\Docdata\StructType\StatusRequest $parameters
     * @return \Models\Docdata\StructType\StatusResponse|bool
     */
    public function status(\Models\Docdata\StructType\StatusRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->status($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named statusExtended
     * Meta informations extracted from the WSDL
     * - documentation: Retrieves an extended report that describes the state of a specified payment order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Models\Docdata\StructType\ExtendedStatusRequest $parameters
     * @return \Models\Docdata\StructType\ExtendedStatusResponse|bool
     */
    public function statusExtended(\Models\Docdata\StructType\ExtendedStatusRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->statusExtended($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Models\Docdata\StructType\ExtendedStatusResponse|\Models\Docdata\StructType\StatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
