<?php

namespace Models\Docdata\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Proceed ServiceType
 * @subpackage Services
 */
class Proceed extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named proceed
     * Meta informations extracted from the WSDL
     * - documentation: Proceeds processing of a payment order in the DocData system. This is a follow-up on the start operation, in case of any required shopper interaction, like 3DS or iDEAL. This operation is called with the result of the shopper
     * interaction and proceeds handling the payment.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Models\Docdata\StructType\ProceedRequest $parameters
     * @return \Models\Docdata\StructType\ProceedResponse|bool
     */
    public function proceed(\Models\Docdata\StructType\ProceedRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->proceed($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Models\Docdata\StructType\ProceedResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
