<?php

namespace Models\Docdata\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named create
     * Meta informations extracted from the WSDL
     * - documentation: Creates a payment order in the DocData system, so it may be processed later.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Models\Docdata\StructType\CreateRequest $parameters
     * @return \Models\Docdata\StructType\CreateResponse|bool
     */
    public function create(\Models\Docdata\StructType\CreateRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Models\Docdata\StructType\CreateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
