<?php

namespace Models\Docdata\EnumType;

/**
 * This class stands for pointOfSalePaymentReceiptType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: The receipt type. A shopper receipt. A merchant receipt.
 * @subpackage Enumerations
 */
class PointOfSalePaymentReceiptType
{
    /**
     * Constant for value 'SHOPPER'
     * @return string 'SHOPPER'
     */
    const VALUE_SHOPPER = 'SHOPPER';
    /**
     * Constant for value 'MERCHANT'
     * @return string 'MERCHANT'
     */
    const VALUE_MERCHANT = 'MERCHANT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SHOPPER
     * @uses self::VALUE_MERCHANT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SHOPPER,
            self::VALUE_MERCHANT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
