<?php

namespace Models\Docdata\EnumType;

/**
 * This class stands for authorizationStatus EnumType
 * Meta informations extracted from the WSDL
 * - documentation: The state of the authorization. Current known values: This is a new payment without any actions performed on it yet. For this payment the risk check was okay. The risk check for this payment triggered. The user has provided details
 * and is authenticated. The payment system could not start the payment due to a technical error. The shopper is authenticated by the acquirer. The shopper is redirected to the acquirer web-site for authentication. The shopper is not authenticated by
 * the acquirer. Unable to do the authentication of the shopper by the acquirer. This payment is authorized. The shopper is redirected to the acquirer web-site for authorization. Requested authorization for this payment, waiting for a notification from
 * acquirer. The payment was not authorized due to a functional error. Unable to do the payment authorization due to a technical error. The payment is canceled. Payment is not canceled, due to functional error. Payment is not canceled, due to technical
 * error. A cancel request sent to acquirer.
 * @subpackage Enumerations
 */
class AuthorizationStatus
{
    /**
     * Constant for value 'NEW'
     * @return string 'NEW'
     */
    const VALUE_NEW = 'NEW';
    /**
     * Constant for value 'RISK_CHECK_OK'
     * @return string 'RISK_CHECK_OK'
     */
    const VALUE_RISK_CHECK_OK = 'RISK_CHECK_OK';
    /**
     * Constant for value 'RISK_CHECK_FAILED'
     * @return string 'RISK_CHECK_FAILED'
     */
    const VALUE_RISK_CHECK_FAILED = 'RISK_CHECK_FAILED';
    /**
     * Constant for value 'STARTED'
     * @return string 'STARTED'
     */
    const VALUE_STARTED = 'STARTED';
    /**
     * Constant for value 'START_ERROR'
     * @return string 'START_ERROR'
     */
    const VALUE_START_ERROR = 'START_ERROR';
    /**
     * Constant for value 'AUTHENTICATED'
     * @return string 'AUTHENTICATED'
     */
    const VALUE_AUTHENTICATED = 'AUTHENTICATED';
    /**
     * Constant for value 'REDIRECTED_FOR_AUTHENTICATION'
     * @return string 'REDIRECTED_FOR_AUTHENTICATION'
     */
    const VALUE_REDIRECTED_FOR_AUTHENTICATION = 'REDIRECTED_FOR_AUTHENTICATION';
    /**
     * Constant for value 'AUTHENTICATION_FAILED'
     * @return string 'AUTHENTICATION_FAILED'
     */
    const VALUE_AUTHENTICATION_FAILED = 'AUTHENTICATION_FAILED';
    /**
     * Constant for value 'AUTHENTICATION_ERROR'
     * @return string 'AUTHENTICATION_ERROR'
     */
    const VALUE_AUTHENTICATION_ERROR = 'AUTHENTICATION_ERROR';
    /**
     * Constant for value 'AUTHORIZED'
     * @return string 'AUTHORIZED'
     */
    const VALUE_AUTHORIZED = 'AUTHORIZED';
    /**
     * Constant for value 'REDIRECTED_FOR_AUTHORIZATION'
     * @return string 'REDIRECTED_FOR_AUTHORIZATION'
     */
    const VALUE_REDIRECTED_FOR_AUTHORIZATION = 'REDIRECTED_FOR_AUTHORIZATION';
    /**
     * Constant for value 'AUTHORIZATION_REQUESTED'
     * @return string 'AUTHORIZATION_REQUESTED'
     */
    const VALUE_AUTHORIZATION_REQUESTED = 'AUTHORIZATION_REQUESTED';
    /**
     * Constant for value 'AUTHORIZATION_FAILED'
     * @return string 'AUTHORIZATION_FAILED'
     */
    const VALUE_AUTHORIZATION_FAILED = 'AUTHORIZATION_FAILED';
    /**
     * Constant for value 'AUTHORIZATION_ERROR'
     * @return string 'AUTHORIZATION_ERROR'
     */
    const VALUE_AUTHORIZATION_ERROR = 'AUTHORIZATION_ERROR';
    /**
     * Constant for value 'CANCELED'
     * @return string 'CANCELED'
     */
    const VALUE_CANCELED = 'CANCELED';
    /**
     * Constant for value 'CANCEL_FAILED'
     * @return string 'CANCEL_FAILED'
     */
    const VALUE_CANCEL_FAILED = 'CANCEL_FAILED';
    /**
     * Constant for value 'CANCEL_ERROR'
     * @return string 'CANCEL_ERROR'
     */
    const VALUE_CANCEL_ERROR = 'CANCEL_ERROR';
    /**
     * Constant for value 'CANCEL_REQUESTED'
     * @return string 'CANCEL_REQUESTED'
     */
    const VALUE_CANCEL_REQUESTED = 'CANCEL_REQUESTED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEW
     * @uses self::VALUE_RISK_CHECK_OK
     * @uses self::VALUE_RISK_CHECK_FAILED
     * @uses self::VALUE_STARTED
     * @uses self::VALUE_START_ERROR
     * @uses self::VALUE_AUTHENTICATED
     * @uses self::VALUE_REDIRECTED_FOR_AUTHENTICATION
     * @uses self::VALUE_AUTHENTICATION_FAILED
     * @uses self::VALUE_AUTHENTICATION_ERROR
     * @uses self::VALUE_AUTHORIZED
     * @uses self::VALUE_REDIRECTED_FOR_AUTHORIZATION
     * @uses self::VALUE_AUTHORIZATION_REQUESTED
     * @uses self::VALUE_AUTHORIZATION_FAILED
     * @uses self::VALUE_AUTHORIZATION_ERROR
     * @uses self::VALUE_CANCELED
     * @uses self::VALUE_CANCEL_FAILED
     * @uses self::VALUE_CANCEL_ERROR
     * @uses self::VALUE_CANCEL_REQUESTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEW,
            self::VALUE_RISK_CHECK_OK,
            self::VALUE_RISK_CHECK_FAILED,
            self::VALUE_STARTED,
            self::VALUE_START_ERROR,
            self::VALUE_AUTHENTICATED,
            self::VALUE_REDIRECTED_FOR_AUTHENTICATION,
            self::VALUE_AUTHENTICATION_FAILED,
            self::VALUE_AUTHENTICATION_ERROR,
            self::VALUE_AUTHORIZED,
            self::VALUE_REDIRECTED_FOR_AUTHORIZATION,
            self::VALUE_AUTHORIZATION_REQUESTED,
            self::VALUE_AUTHORIZATION_FAILED,
            self::VALUE_AUTHORIZATION_ERROR,
            self::VALUE_CANCELED,
            self::VALUE_CANCEL_FAILED,
            self::VALUE_CANCEL_ERROR,
            self::VALUE_CANCEL_REQUESTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
