<?php

namespace Models\Docdata;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'country' => '\\Models\\Docdata\\StructType\\Country',
            'language' => '\\Models\\Docdata\\StructType\\Language',
            'expiryDate' => '\\Models\\Docdata\\StructType\\ExpiryDate',
            'vat' => '\\Models\\Docdata\\StructType\\Vat',
            'amount' => '\\Models\\Docdata\\StructType\\Amount',
            'menuPreferences' => '\\Models\\Docdata\\StructType\\MenuPreferences',
            'css' => '\\Models\\Docdata\\StructType\\Css',
            'parameters' => '\\Models\\Docdata\\StructType\\Parameters',
            'parameter' => '\\Models\\Docdata\\StructType\\Parameter',
            'consideredSafe' => '\\Models\\Docdata\\StructType\\ConsideredSafe',
            'name' => '\\Models\\Docdata\\StructType\\Name',
            'destination' => '\\Models\\Docdata\\StructType\\Destination',
            'technicalIntegrationInfo' => '\\Models\\Docdata\\StructType\\TechnicalIntegrationInfo',
            'address' => '\\Models\\Docdata\\StructType\\Address',
            'customer' => '\\Models\\Docdata\\StructType\\Customer',
            'shopper' => '\\Models\\Docdata\\StructType\\Shopper',
            'company' => '\\Models\\Docdata\\StructType\\Company',
            'merchant' => '\\Models\\Docdata\\StructType\\Merchant',
            'paymentPreferences' => '\\Models\\Docdata\\StructType\\PaymentPreferences',
            'exhortation' => '\\Models\\Docdata\\StructType\\Exhortation',
            'paymentRequest' => '\\Models\\Docdata\\StructType\\PaymentRequest',
            'paymentReference' => '\\Models\\Docdata\\StructType\\PaymentReference',
            'threeDomainSecureAuthenticationResult' => '\\Models\\Docdata\\StructType\\ThreeDomainSecureAuthenticationResult',
            'iDealAuthorizationResult' => '\\Models\\Docdata\\StructType\\IDealAuthorizationResult',
            'refundItems' => '\\Models\\Docdata\\StructType\\RefundItems',
            'additionalRefund' => '\\Models\\Docdata\\StructType\\AdditionalRefund',
            'itemLine' => '\\Models\\Docdata\\StructType\\ItemLine',
            'paymentResponse' => '\\Models\\Docdata\\StructType\\PaymentResponse',
            'paymentSuccess' => '\\Models\\Docdata\\StructType\\PaymentSuccess',
            'paymentError' => '\\Models\\Docdata\\StructType\\PaymentError',
            'invoice' => '\\Models\\Docdata\\StructType\\Invoice',
            'totalVatAmount' => '\\Models\\Docdata\\StructType\\TotalVatAmount',
            'exhortationPeriod' => '\\Models\\Docdata\\StructType\\ExhortationPeriod',
            'error' => '\\Models\\Docdata\\StructType\\Error',
            'success' => '\\Models\\Docdata\\StructType\\Success',
            'item' => '\\Models\\Docdata\\StructType\\Item',
            'quantity' => '\\Models\\Docdata\\StructType\\Quantity',
            'paymentRequestInput' => '\\Models\\Docdata\\StructType\\PaymentRequestInput',
            'cardPaymentInput' => '\\Models\\Docdata\\StructType\\CardPaymentInput',
            'directDebitPaymentInput' => '\\Models\\Docdata\\StructType\\DirectDebitPaymentInput',
            'bankTransferPaymentInput' => '\\Models\\Docdata\\StructType\\BankTransferPaymentInput',
            'pointOfSalePaymentInput' => '\\Models\\Docdata\\StructType\\PointOfSalePaymentInput',
            'offlinePaymentInput' => '\\Models\\Docdata\\StructType\\OfflinePaymentInput',
            'elvPaymentInput' => '\\Models\\Docdata\\StructType\\ElvPaymentInput',
            'iDealPaymentInput' => '\\Models\\Docdata\\StructType\\IDealPaymentInput',
            'statusReport' => '\\Models\\Docdata\\StructType\\StatusReport',
            'approximateTotals' => '\\Models\\Docdata\\StructType\\ApproximateTotals',
            'payment' => '\\Models\\Docdata\\StructType\\Payment',
            'paymentInfo' => '\\Models\\Docdata\\StructType\\PaymentInfo',
            'riskCheck' => '\\Models\\Docdata\\StructType\\RiskCheck',
            'check' => '\\Models\\Docdata\\StructType\\Check',
            'amexPaymentInfo' => '\\Models\\Docdata\\StructType\\AmexPaymentInfo',
            'masterCardPaymentInfo' => '\\Models\\Docdata\\StructType\\MasterCardPaymentInfo',
            'visaPaymentInfo' => '\\Models\\Docdata\\StructType\\VisaPaymentInfo',
            'maestroPaymentInfo' => '\\Models\\Docdata\\StructType\\MaestroPaymentInfo',
            'misterCashPaymentInfo' => '\\Models\\Docdata\\StructType\\MisterCashPaymentInfo',
            'iDealPaymentInfo' => '\\Models\\Docdata\\StructType\\IDealPaymentInfo',
            'sofortPaymentInfo' => '\\Models\\Docdata\\StructType\\SofortPaymentInfo',
            'bankTransferPaymentInfo' => '\\Models\\Docdata\\StructType\\BankTransferPaymentInfo',
            'giftCardPaymentInfo' => '\\Models\\Docdata\\StructType\\GiftCardPaymentInfo',
            'openInvoicePaymentInfo' => '\\Models\\Docdata\\StructType\\OpenInvoicePaymentInfo',
            'sepaDirectDebitPaymentInfo' => '\\Models\\Docdata\\StructType\\SepaDirectDebitPaymentInfo',
            'elvPaymentInfo' => '\\Models\\Docdata\\StructType\\ElvPaymentInfo',
            'pointOfSalePaymentInfo' => '\\Models\\Docdata\\StructType\\PointOfSalePaymentInfo',
            'pointOfSalePaymentReceipt' => '\\Models\\Docdata\\StructType\\PointOfSalePaymentReceipt',
            'pointOfSalePaymentFormattedReceipt' => '\\Models\\Docdata\\StructType\\PointOfSalePaymentFormattedReceipt',
            'pointOfSalePaymentReceiptValues' => '\\Models\\Docdata\\StructType\\PointOfSalePaymentReceiptValues',
            'value' => '\\Models\\Docdata\\StructType\\Value',
            'systemPaymentInfo' => '\\Models\\Docdata\\StructType\\SystemPaymentInfo',
            'shopperBankAccount' => '\\Models\\Docdata\\StructType\\ShopperBankAccount',
            'authorization' => '\\Models\\Docdata\\StructType\\Authorization',
            'capture' => '\\Models\\Docdata\\StructType\\Capture',
            'refund' => '\\Models\\Docdata\\StructType\\Refund',
            'chargeback' => '\\Models\\Docdata\\StructType\\Chargeback',
            'reversal' => '\\Models\\Docdata\\StructType\\Reversal',
            'createRequest' => '\\Models\\Docdata\\StructType\\CreateRequest',
            'createResponse' => '\\Models\\Docdata\\StructType\\CreateResponse',
            'createSuccess' => '\\Models\\Docdata\\StructType\\CreateSuccess',
            'createErrors' => '\\Models\\Docdata\\StructType\\CreateErrors',
            'refundRequest' => '\\Models\\Docdata\\StructType\\RefundRequest',
            'refundResponse' => '\\Models\\Docdata\\StructType\\RefundResponse',
            'refundErrors' => '\\Models\\Docdata\\StructType\\RefundErrors',
            'refundSuccess' => '\\Models\\Docdata\\StructType\\RefundSuccess',
            'cancelRequest' => '\\Models\\Docdata\\StructType\\CancelRequest',
            'cancelResponse' => '\\Models\\Docdata\\StructType\\CancelResponse',
            'cancelSuccess' => '\\Models\\Docdata\\StructType\\CancelSuccess',
            'cancelErrors' => '\\Models\\Docdata\\StructType\\CancelErrors',
            'startRequest' => '\\Models\\Docdata\\StructType\\StartRequest',
            'startResponse' => '\\Models\\Docdata\\StructType\\StartResponse',
            'startErrors' => '\\Models\\Docdata\\StructType\\StartErrors',
            'startSuccess' => '\\Models\\Docdata\\StructType\\StartSuccess',
            'proceedRequest' => '\\Models\\Docdata\\StructType\\ProceedRequest',
            'proceedResponse' => '\\Models\\Docdata\\StructType\\ProceedResponse',
            'proceedErrors' => '\\Models\\Docdata\\StructType\\ProceedErrors',
            'proceedSuccess' => '\\Models\\Docdata\\StructType\\ProceedSuccess',
            'captureRequest' => '\\Models\\Docdata\\StructType\\CaptureRequest',
            'captureResponse' => '\\Models\\Docdata\\StructType\\CaptureResponse',
            'captureErrors' => '\\Models\\Docdata\\StructType\\CaptureErrors',
            'captureSuccess' => '\\Models\\Docdata\\StructType\\CaptureSuccess',
            'statusRequest' => '\\Models\\Docdata\\StructType\\StatusRequest',
            'statusResponse' => '\\Models\\Docdata\\StructType\\StatusResponse',
            'extendedStatusRequest' => '\\Models\\Docdata\\StructType\\ExtendedStatusRequest',
            'extendedStatusResponse' => '\\Models\\Docdata\\StructType\\ExtendedStatusResponse',
            'statusErrors' => '\\Models\\Docdata\\StructType\\StatusErrors',
            'statusSuccess' => '\\Models\\Docdata\\StructType\\StatusSuccess',
            'listPaymentMethodsRequest' => '\\Models\\Docdata\\StructType\\ListPaymentMethodsRequest',
            'listPaymentMethodsResponse' => '\\Models\\Docdata\\StructType\\ListPaymentMethodsResponse',
            'listPaymentMethodsErrors' => '\\Models\\Docdata\\StructType\\ListPaymentMethodsErrors',
            'listPaymentMethodsSuccess' => '\\Models\\Docdata\\StructType\\ListPaymentMethodsSuccess',
            'paymentMethod' => '\\Models\\Docdata\\StructType\\PaymentMethod',
            'mandateSummary' => '\\Models\\Docdata\\StructType\\MandateSummary',
            'sepaBankAccount' => '\\Models\\Docdata\\StructType\\SepaBankAccount',
            'salesPerson' => '\\Models\\Docdata\\StructType\\SalesPerson',
            'register' => '\\Models\\Docdata\\StructType\\Register',
            'offlinePaymentInfo' => '\\Models\\Docdata\\StructType\\OfflinePaymentInfo',
            'token' => '\\Models\\Docdata\\StructType\\Token',
            'cardTokenInput' => '\\Models\\Docdata\\StructType\\CardTokenInput',
            'paymentRedirect' => '\\Models\\Docdata\\StructType\\PaymentRedirect',
            'shopperInfo' => '\\Models\\Docdata\\StructType\\ShopperInfo',
        );
    }
}
