<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for visaPaymentInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Visa credit card payment information.
 * @subpackage Structs
 */
class VisaPaymentInfo extends AbstractStructBase
{
    /**
     * The cardHolder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $cardHolder;
    /**
     * The cardCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $cardCountry;
    /**
     * The panLast4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $panLast4;
    /**
     * The refusalReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 250
     * - minLength: 1
     * @var string
     */
    public $refusalReason;
    /**
     * The mandateNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $mandateNumber;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for visaPaymentInfo
     * @uses VisaPaymentInfo::setCardHolder()
     * @uses VisaPaymentInfo::setCardCountry()
     * @uses VisaPaymentInfo::setPanLast4()
     * @uses VisaPaymentInfo::setRefusalReason()
     * @uses VisaPaymentInfo::setMandateNumber()
     * @uses VisaPaymentInfo::setAny()
     * @param string $cardHolder
     * @param string $cardCountry
     * @param string $panLast4
     * @param string $refusalReason
     * @param string $mandateNumber
     * @param \DOMDocument $any
     */
    public function __construct($cardHolder = null, $cardCountry = null, $panLast4 = null, $refusalReason = null, $mandateNumber = null, \DOMDocument $any = null)
    {
        $this
            ->setCardHolder($cardHolder)
            ->setCardCountry($cardCountry)
            ->setPanLast4($panLast4)
            ->setRefusalReason($refusalReason)
            ->setMandateNumber($mandateNumber)
            ->setAny($any);
    }
    /**
     * Get cardHolder value
     * @return string
     */
    public function getCardHolder()
    {
        return $this->cardHolder;
    }
    /**
     * Set cardHolder value
     * @param string $cardHolder
     * @return \Models\Docdata\StructType\VisaPaymentInfo
     */
    public function setCardHolder($cardHolder = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cardHolder) && strlen($cardHolder) > 100) || (is_array($cardHolder) && count($cardHolder) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($cardHolder) ? strlen($cardHolder) : count($cardHolder)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($cardHolder) && strlen($cardHolder) < 1) || (is_array($cardHolder) && count($cardHolder) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cardHolder) && !is_string($cardHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardHolder)), __LINE__);
        }
        $this->cardHolder = $cardHolder;
        return $this;
    }
    /**
     * Get cardCountry value
     * @return string|null
     */
    public function getCardCountry()
    {
        return $this->cardCountry;
    }
    /**
     * Set cardCountry value
     * @param string $cardCountry
     * @return \Models\Docdata\StructType\VisaPaymentInfo
     */
    public function setCardCountry($cardCountry = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cardCountry) && strlen($cardCountry) > 50) || (is_array($cardCountry) && count($cardCountry) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($cardCountry) ? strlen($cardCountry) : count($cardCountry)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($cardCountry) && strlen($cardCountry) < 1) || (is_array($cardCountry) && count($cardCountry) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cardCountry) && !is_string($cardCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardCountry)), __LINE__);
        }
        $this->cardCountry = $cardCountry;
        return $this;
    }
    /**
     * Get panLast4 value
     * @return string|null
     */
    public function getPanLast4()
    {
        return $this->panLast4;
    }
    /**
     * Set panLast4 value
     * @param string $panLast4
     * @return \Models\Docdata\StructType\VisaPaymentInfo
     */
    public function setPanLast4($panLast4 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($panLast4) && strlen($panLast4) > 50) || (is_array($panLast4) && count($panLast4) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($panLast4) ? strlen($panLast4) : count($panLast4)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($panLast4) && strlen($panLast4) < 1) || (is_array($panLast4) && count($panLast4) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($panLast4) && !is_string($panLast4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($panLast4)), __LINE__);
        }
        $this->panLast4 = $panLast4;
        return $this;
    }
    /**
     * Get refusalReason value
     * @return string|null
     */
    public function getRefusalReason()
    {
        return $this->refusalReason;
    }
    /**
     * Set refusalReason value
     * @param string $refusalReason
     * @return \Models\Docdata\StructType\VisaPaymentInfo
     */
    public function setRefusalReason($refusalReason = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($refusalReason) && strlen($refusalReason) > 250) || (is_array($refusalReason) && count($refusalReason) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($refusalReason) ? strlen($refusalReason) : count($refusalReason)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($refusalReason) && strlen($refusalReason) < 1) || (is_array($refusalReason) && count($refusalReason) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($refusalReason) && !is_string($refusalReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refusalReason)), __LINE__);
        }
        $this->refusalReason = $refusalReason;
        return $this;
    }
    /**
     * Get mandateNumber value
     * @return string|null
     */
    public function getMandateNumber()
    {
        return $this->mandateNumber;
    }
    /**
     * Set mandateNumber value
     * @param string $mandateNumber
     * @return \Models\Docdata\StructType\VisaPaymentInfo
     */
    public function setMandateNumber($mandateNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mandateNumber) && strlen($mandateNumber) > 50) || (is_array($mandateNumber) && count($mandateNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($mandateNumber) ? strlen($mandateNumber) : count($mandateNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($mandateNumber) && strlen($mandateNumber) < 1) || (is_array($mandateNumber) && count($mandateNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mandateNumber) && !is_string($mandateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mandateNumber)), __LINE__);
        }
        $this->mandateNumber = $mandateNumber;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\VisaPaymentInfo::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\VisaPaymentInfo
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\VisaPaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
