<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vat StructType
 * @subpackage Structs
 */
class Vat extends AbstractStructBase
{
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Amount
     */
    public $amount;
    /**
     * The rate
     * Meta informations extracted from the WSDL
     * - use: required
     * - minInclusive: 0
     * - whiteSpace: collapse
     * @var float
     */
    public $rate;
    /**
     * Constructor method for vat
     * @uses Vat::setAmount()
     * @uses Vat::setRate()
     * @param \Models\Docdata\StructType\Amount $amount
     * @param float $rate
     */
    public function __construct(\Models\Docdata\StructType\Amount $amount = null, $rate = null)
    {
        $this
            ->setAmount($amount)
            ->setRate($rate);
    }
    /**
     * Get amount value
     * @return \Models\Docdata\StructType\Amount
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param \Models\Docdata\StructType\Amount $amount
     * @return \Models\Docdata\StructType\Vat
     */
    public function setAmount(\Models\Docdata\StructType\Amount $amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get rate value
     * @return float
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \Models\Docdata\StructType\Vat
     */
    public function setRate($rate = null)
    {
        $this->rate = $rate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\Vat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
