<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for token StructType
 * @subpackage Structs
 */
class Token extends AbstractStructBase
{
    /**
     * The amexTokenInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\CardTokenInput
     */
    public $amexTokenInput;
    /**
     * The masterCardTokenInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\CardTokenInput
     */
    public $masterCardTokenInput;
    /**
     * The visaTokenInput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\CardTokenInput
     */
    public $visaTokenInput;
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - documentation: Key of the token
     * - use: required
     * - maxLength: 512
     * - minLength: 1
     * @var string
     */
    public $key;
    /**
     * Constructor method for token
     * @uses Token::setAmexTokenInput()
     * @uses Token::setMasterCardTokenInput()
     * @uses Token::setVisaTokenInput()
     * @uses Token::setKey()
     * @param \Models\Docdata\StructType\CardTokenInput $amexTokenInput
     * @param \Models\Docdata\StructType\CardTokenInput $masterCardTokenInput
     * @param \Models\Docdata\StructType\CardTokenInput $visaTokenInput
     * @param string $key
     */
    public function __construct(\Models\Docdata\StructType\CardTokenInput $amexTokenInput = null, \Models\Docdata\StructType\CardTokenInput $masterCardTokenInput = null, \Models\Docdata\StructType\CardTokenInput $visaTokenInput = null, $key = null)
    {
        $this
            ->setAmexTokenInput($amexTokenInput)
            ->setMasterCardTokenInput($masterCardTokenInput)
            ->setVisaTokenInput($visaTokenInput)
            ->setKey($key);
    }
    /**
     * Get amexTokenInput value
     * @return \Models\Docdata\StructType\CardTokenInput
     */
    public function getAmexTokenInput()
    {
        return $this->amexTokenInput;
    }
    /**
     * Set amexTokenInput value
     * @param \Models\Docdata\StructType\CardTokenInput $amexTokenInput
     * @return \Models\Docdata\StructType\Token
     */
    public function setAmexTokenInput(\Models\Docdata\StructType\CardTokenInput $amexTokenInput = null)
    {
        $this->amexTokenInput = $amexTokenInput;
        return $this;
    }
    /**
     * Get masterCardTokenInput value
     * @return \Models\Docdata\StructType\CardTokenInput
     */
    public function getMasterCardTokenInput()
    {
        return $this->masterCardTokenInput;
    }
    /**
     * Set masterCardTokenInput value
     * @param \Models\Docdata\StructType\CardTokenInput $masterCardTokenInput
     * @return \Models\Docdata\StructType\Token
     */
    public function setMasterCardTokenInput(\Models\Docdata\StructType\CardTokenInput $masterCardTokenInput = null)
    {
        $this->masterCardTokenInput = $masterCardTokenInput;
        return $this;
    }
    /**
     * Get visaTokenInput value
     * @return \Models\Docdata\StructType\CardTokenInput
     */
    public function getVisaTokenInput()
    {
        return $this->visaTokenInput;
    }
    /**
     * Set visaTokenInput value
     * @param \Models\Docdata\StructType\CardTokenInput $visaTokenInput
     * @return \Models\Docdata\StructType\Token
     */
    public function setVisaTokenInput(\Models\Docdata\StructType\CardTokenInput $visaTokenInput = null)
    {
        $this->visaTokenInput = $visaTokenInput;
        return $this;
    }
    /**
     * Get key value
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \Models\Docdata\StructType\Token
     */
    public function setKey($key = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($key) && strlen($key) > 512) || (is_array($key) && count($key) > 512)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 512 element(s) or a scalar of 512 character(s) at most, "%d" length given', is_scalar($key) ? strlen($key) : count($key)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($key) && strlen($key) < 1) || (is_array($key) && count($key) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\Token
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
