<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for startRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Allows to request the start of a new payment.
 * @subpackage Structs
 */
class StartRequest extends AbstractStructBase
{
    /**
     * The merchant
     * Meta informations extracted from the WSDL
     * - documentation: Merchant's credentials.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Merchant
     */
    public $merchant;
    /**
     * The paymentOrderKey
     * Meta informations extracted from the WSDL
     * - documentation: Payment order key belonging to the order for which a transaction needs to be started.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 32
     * - minLength: 32
     * - pattern: [A-Z,0-9]{32}
     * @var string
     */
    public $paymentOrderKey;
    /**
     * The recurringPaymentRequest
     * Meta informations extracted from the WSDL
     * - documentation: Specifies a request for a recurring payment. It should target an existing previous payment that will be used to start a new payment with directly. Reservations are also made as the starting point for upcoming repeated payments if
     * needed. Must be specified if not giving direct payment request input.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\PaymentRequest
     */
    public $recurringPaymentRequest;
    /**
     * The payment
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the details needed for starting a payment for a shopper without showing the hosted payment pages. Must be specified if not a subsequent recurring payment.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\PaymentRequestInput
     */
    public $payment;
    /**
     * The token
     * Meta informations extracted from the WSDL
     * - documentation: Pay with a token.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Token
     */
    public $token;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - fixed: 1.3
     * - use: required
     * @var float
     */
    public $version;
    /**
     * The paymentAmount
     * Meta informations extracted from the WSDL
     * - documentation: Optional payment amount to be used. If left empty, the full payment order's amount will be used.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\Amount
     */
    public $paymentAmount;
    /**
     * The returnUrl
     * Meta informations extracted from the WSDL
     * - documentation: Optional return url to be used. If left empty, no return url will be used. (Limit is set by Internet Explorer of 2083 characters)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 2048
     * - minLength: 1
     * @var string
     */
    public $returnUrl;
    /**
     * The shopperInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\ShopperInfo
     */
    public $shopperInfo;
    /**
     * The integrationInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\TechnicalIntegrationInfo
     */
    public $integrationInfo;
    /**
     * The testExtensibility
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Test extensibility of client implementation by returning test elements and attributes indicated by with the names and string value "_any".
     * - use: optional
     * @var bool
     */
    public $testExtensibility;
    /**
     * Constructor method for startRequest
     * @uses StartRequest::setMerchant()
     * @uses StartRequest::setPaymentOrderKey()
     * @uses StartRequest::setRecurringPaymentRequest()
     * @uses StartRequest::setPayment()
     * @uses StartRequest::setToken()
     * @uses StartRequest::setVersion()
     * @uses StartRequest::setPaymentAmount()
     * @uses StartRequest::setReturnUrl()
     * @uses StartRequest::setShopperInfo()
     * @uses StartRequest::setIntegrationInfo()
     * @uses StartRequest::setTestExtensibility()
     * @param \Models\Docdata\StructType\Merchant $merchant
     * @param string $paymentOrderKey
     * @param \Models\Docdata\StructType\PaymentRequest $recurringPaymentRequest
     * @param \Models\Docdata\StructType\PaymentRequestInput $payment
     * @param \Models\Docdata\StructType\Token $token
     * @param float $version
     * @param \Models\Docdata\StructType\Amount $paymentAmount
     * @param string $returnUrl
     * @param \Models\Docdata\StructType\ShopperInfo $shopperInfo
     * @param \Models\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo
     * @param bool $testExtensibility
     */
    public function __construct(\Models\Docdata\StructType\Merchant $merchant = null, $paymentOrderKey = null, \Models\Docdata\StructType\PaymentRequest $recurringPaymentRequest = null, \Models\Docdata\StructType\PaymentRequestInput $payment = null, \Models\Docdata\StructType\Token $token = null, $version = null, \Models\Docdata\StructType\Amount $paymentAmount = null, $returnUrl = null, \Models\Docdata\StructType\ShopperInfo $shopperInfo = null, \Models\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo = null, $testExtensibility = false)
    {
        $this
            ->setMerchant($merchant)
            ->setPaymentOrderKey($paymentOrderKey)
            ->setRecurringPaymentRequest($recurringPaymentRequest)
            ->setPayment($payment)
            ->setToken($token)
            ->setVersion($version)
            ->setPaymentAmount($paymentAmount)
            ->setReturnUrl($returnUrl)
            ->setShopperInfo($shopperInfo)
            ->setIntegrationInfo($integrationInfo)
            ->setTestExtensibility($testExtensibility);
    }
    /**
     * Get merchant value
     * @return \Models\Docdata\StructType\Merchant
     */
    public function getMerchant()
    {
        return $this->merchant;
    }
    /**
     * Set merchant value
     * @param \Models\Docdata\StructType\Merchant $merchant
     * @return \Models\Docdata\StructType\StartRequest
     */
    public function setMerchant(\Models\Docdata\StructType\Merchant $merchant = null)
    {
        $this->merchant = $merchant;
        return $this;
    }
    /**
     * Get paymentOrderKey value
     * @return string
     */
    public function getPaymentOrderKey()
    {
        return $this->paymentOrderKey;
    }
    /**
     * Set paymentOrderKey value
     * @param string $paymentOrderKey
     * @return \Models\Docdata\StructType\StartRequest
     */
    public function setPaymentOrderKey($paymentOrderKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($paymentOrderKey) && strlen($paymentOrderKey) > 32) || (is_array($paymentOrderKey) && count($paymentOrderKey) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($paymentOrderKey) ? strlen($paymentOrderKey) : count($paymentOrderKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($paymentOrderKey) && strlen($paymentOrderKey) < 32) || (is_array($paymentOrderKey) && count($paymentOrderKey) < 32)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($paymentOrderKey) && !preg_match('/[A-Z,0-9]{32}/', $paymentOrderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z,0-9]{32}", "%s" given', var_export($paymentOrderKey, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($paymentOrderKey) && !is_string($paymentOrderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentOrderKey)), __LINE__);
        }
        $this->paymentOrderKey = $paymentOrderKey;
        return $this;
    }
    /**
     * Get recurringPaymentRequest value
     * @return \Models\Docdata\StructType\PaymentRequest
     */
    public function getRecurringPaymentRequest()
    {
        return $this->recurringPaymentRequest;
    }
    /**
     * Set recurringPaymentRequest value
     * @param \Models\Docdata\StructType\PaymentRequest $recurringPaymentRequest
     * @return \Models\Docdata\StructType\StartRequest
     */
    public function setRecurringPaymentRequest(\Models\Docdata\StructType\PaymentRequest $recurringPaymentRequest = null)
    {
        $this->recurringPaymentRequest = $recurringPaymentRequest;
        return $this;
    }
    /**
     * Get payment value
     * @return \Models\Docdata\StructType\PaymentRequestInput
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @param \Models\Docdata\StructType\PaymentRequestInput $payment
     * @return \Models\Docdata\StructType\StartRequest
     */
    public function setPayment(\Models\Docdata\StructType\PaymentRequestInput $payment = null)
    {
        $this->payment = $payment;
        return $this;
    }
    /**
     * Get token value
     * @return \Models\Docdata\StructType\Token
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param \Models\Docdata\StructType\Token $token
     * @return \Models\Docdata\StructType\StartRequest
     */
    public function setToken(\Models\Docdata\StructType\Token $token = null)
    {
        $this->token = $token;
        return $this;
    }
    /**
     * Get version value
     * @return float
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param float $version
     * @return \Models\Docdata\StructType\StartRequest
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Get paymentAmount value
     * @return \Models\Docdata\StructType\Amount|null
     */
    public function getPaymentAmount()
    {
        return $this->paymentAmount;
    }
    /**
     * Set paymentAmount value
     * @param \Models\Docdata\StructType\Amount $paymentAmount
     * @return \Models\Docdata\StructType\StartRequest
     */
    public function setPaymentAmount(\Models\Docdata\StructType\Amount $paymentAmount = null)
    {
        $this->paymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get returnUrl value
     * @return string|null
     */
    public function getReturnUrl()
    {
        return $this->returnUrl;
    }
    /**
     * Set returnUrl value
     * @param string $returnUrl
     * @return \Models\Docdata\StructType\StartRequest
     */
    public function setReturnUrl($returnUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($returnUrl) && strlen($returnUrl) > 2048) || (is_array($returnUrl) && count($returnUrl) > 2048)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2048 element(s) or a scalar of 2048 character(s) at most, "%d" length given', is_scalar($returnUrl) ? strlen($returnUrl) : count($returnUrl)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($returnUrl) && strlen($returnUrl) < 1) || (is_array($returnUrl) && count($returnUrl) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($returnUrl) && !is_string($returnUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnUrl)), __LINE__);
        }
        $this->returnUrl = $returnUrl;
        return $this;
    }
    /**
     * Get shopperInfo value
     * @return \Models\Docdata\StructType\ShopperInfo|null
     */
    public function getShopperInfo()
    {
        return $this->shopperInfo;
    }
    /**
     * Set shopperInfo value
     * @param \Models\Docdata\StructType\ShopperInfo $shopperInfo
     * @return \Models\Docdata\StructType\StartRequest
     */
    public function setShopperInfo(\Models\Docdata\StructType\ShopperInfo $shopperInfo = null)
    {
        $this->shopperInfo = $shopperInfo;
        return $this;
    }
    /**
     * Get integrationInfo value
     * @return \Models\Docdata\StructType\TechnicalIntegrationInfo|null
     */
    public function getIntegrationInfo()
    {
        return $this->integrationInfo;
    }
    /**
     * Set integrationInfo value
     * @param \Models\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo
     * @return \Models\Docdata\StructType\StartRequest
     */
    public function setIntegrationInfo(\Models\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo = null)
    {
        $this->integrationInfo = $integrationInfo;
        return $this;
    }
    /**
     * Get testExtensibility value
     * @return bool|null
     */
    public function getTestExtensibility()
    {
        return $this->testExtensibility;
    }
    /**
     * Set testExtensibility value
     * @param bool $testExtensibility
     * @return \Models\Docdata\StructType\StartRequest
     */
    public function setTestExtensibility($testExtensibility = false)
    {
        $this->testExtensibility = $testExtensibility;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\StartRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
