<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sepaDirectDebitPaymentInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: SEPA Direct Debit payment information.
 * @subpackage Structs
 */
class SepaDirectDebitPaymentInfo extends AbstractStructBase
{
    /**
     * The bic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1 | 1
     * - minOccurs: 0 | 0
     * - maxLength: 11
     * - minLength: 8
     * - type: ddp:bic
     * @var string
     */
    public $bic;
    /**
     * The iban
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1 | 1
     * - minOccurs: 0 | 1
     * - maxLength: 34
     * - minLength: 15
     * - type: ddp:iban
     * @var string
     */
    public $iban;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\Country
     */
    public $country;
    /**
     * The mandateNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $mandateNumber;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for sepaDirectDebitPaymentInfo
     * @uses SepaDirectDebitPaymentInfo::setBic()
     * @uses SepaDirectDebitPaymentInfo::setIban()
     * @uses SepaDirectDebitPaymentInfo::setCountry()
     * @uses SepaDirectDebitPaymentInfo::setMandateNumber()
     * @uses SepaDirectDebitPaymentInfo::setAny()
     * @param string $bic
     * @param string $iban
     * @param \Models\Docdata\StructType\Country $country
     * @param string $mandateNumber
     * @param \DOMDocument $any
     */
    public function __construct($bic = null, $iban = null, \Models\Docdata\StructType\Country $country = null, $mandateNumber = null, \DOMDocument $any = null)
    {
        $this
            ->setBic($bic)
            ->setIban($iban)
            ->setCountry($country)
            ->setMandateNumber($mandateNumber)
            ->setAny($any);
    }
    /**
     * Get bic value
     * @return string
     */
    public function getBic()
    {
        return $this->bic;
    }
    /**
     * Set bic value
     * @param string $bic
     * @return \Models\Docdata\StructType\SepaDirectDebitPaymentInfo
     */
    public function setBic($bic = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bic) && strlen($bic) > 11) || (is_array($bic) && count($bic) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($bic) ? strlen($bic) : count($bic)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bic) && strlen($bic) < 8) || (is_array($bic) && count($bic) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bic) && !is_string($bic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bic)), __LINE__);
        }
        $this->bic = $bic;
        return $this;
    }
    /**
     * Get iban value
     * @return string
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \Models\Docdata\StructType\SepaDirectDebitPaymentInfo
     */
    public function setIban($iban = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iban) && strlen($iban) > 34) || (is_array($iban) && count($iban) > 34)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 34 element(s) or a scalar of 34 character(s) at most, "%d" length given', is_scalar($iban) ? strlen($iban) : count($iban)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iban) && strlen($iban) < 15) || (is_array($iban) && count($iban) < 15)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
    /**
     * Get country value
     * @return \Models\Docdata\StructType\Country|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param \Models\Docdata\StructType\Country $country
     * @return \Models\Docdata\StructType\SepaDirectDebitPaymentInfo
     */
    public function setCountry(\Models\Docdata\StructType\Country $country = null)
    {
        $this->country = $country;
        return $this;
    }
    /**
     * Get mandateNumber value
     * @return string|null
     */
    public function getMandateNumber()
    {
        return $this->mandateNumber;
    }
    /**
     * Set mandateNumber value
     * @param string $mandateNumber
     * @return \Models\Docdata\StructType\SepaDirectDebitPaymentInfo
     */
    public function setMandateNumber($mandateNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mandateNumber) && strlen($mandateNumber) > 50) || (is_array($mandateNumber) && count($mandateNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($mandateNumber) ? strlen($mandateNumber) : count($mandateNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($mandateNumber) && strlen($mandateNumber) < 1) || (is_array($mandateNumber) && count($mandateNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mandateNumber) && !is_string($mandateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mandateNumber)), __LINE__);
        }
        $this->mandateNumber = $mandateNumber;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\SepaDirectDebitPaymentInfo::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\SepaDirectDebitPaymentInfo
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\SepaDirectDebitPaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
